/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.cli.logging;

import com.swirlds.cli.logging.DefaultFormattableString;
import com.swirlds.cli.logging.FormattableString;
import com.swirlds.cli.logging.HtmlTagFactory;
import com.swirlds.cli.logging.LogProcessingUtils;
import com.swirlds.cli.logging.NonStandardLog;
import com.swirlds.cli.logging.PlatformStatusLog;
import com.swirlds.common.formatting.TextEffect;
import com.swirlds.common.formatting.UnitFormat;
import com.swirlds.common.formatting.UnitFormatter;
import com.swirlds.common.units.TimeUnit;
import com.swirlds.common.units.Unit;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;

public class LogLine
implements FormattableString {
    public final Logger logger = LogManager.getLogger();
    public static final String CAPTURED_WHITESPACE_REGEX = "(\\s+)";
    public static final String TIMESTAMP_REGEX = "(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}\\.\\d+)";
    public static final String LOG_NUMBER_REGEX = "(\\d+)";
    public static final String LOG_LEVEL_REGEX = "(TRACE|DEBUG|INFO|WARN|ERROR|FATAL)";
    public static final String MARKER_REGEX = "([A-Za-z0-9_]+)";
    public static final String THREAD_NAME_REGEX = "(<<?[^>]+>>?)";
    public static final String CLASS_THREAD_NAME_REGEX = "([A-Za-z0-9_]+)";
    public static final String COLON_SPACE_REGEX = "(: )";
    public static final String REMAINDER_OF_LINE_REGEX = "(.*)";
    public static final TextEffect TIMESTAMP_COLOR = TextEffect.GRAY;
    public static final TextEffect LOG_NUMBER_COLOR = TextEffect.WHITE;
    public static final TextEffect LOG_MARKER_COLOR = TextEffect.BRIGHT_BLUE;
    public static final TextEffect THREAD_NAME_COLOR = TextEffect.BRIGHT_WHITE;
    public static final TextEffect CLASS_NAME_COLOR = TextEffect.BRIGHT_CYAN;
    public static final TextEffect HARMLESS_LOG_LEVEL_COLOR = TextEffect.BRIGHT_GREEN;
    public static final TextEffect WARN_LOG_LEVEL_COLOR = TextEffect.BRIGHT_YELLOW;
    public static final TextEffect ERROR_LOG_LEVEL_COLOR = TextEffect.BRIGHT_RED;
    public static final String FULL_REGEX = "(\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}\\.\\d+)(\\s+)(\\d+)(\\s+)(TRACE|DEBUG|INFO|WARN|ERROR|FATAL)(\\s+)([A-Za-z0-9_]+)(\\s+)(<<?[^>]+>>?)(\\s+)([A-Za-z0-9_]+)(: )(.*)";
    private final String originalLogString;
    private final ZoneId zoneId;
    private final Instant timestamp;
    private final String timestampOriginalString;
    private final String logNumber;
    private final String logLevel;
    private final String marker;
    private final String threadName;
    private final String className;
    private final String colonSpace;
    private final FormattableString remainderOfLine;
    private final List<String> whitespaces = new ArrayList<String>();
    private final NodeId nodeId;
    private Instant logStartTime = null;
    private NonStandardLog additionalLines;

    public LogLine(@NonNull String logLineString, @NonNull ZoneId zoneId, @Nullable NodeId nodeId) {
        this.originalLogString = Objects.requireNonNull(logLineString);
        this.zoneId = Objects.requireNonNull(zoneId);
        this.nodeId = nodeId;
        Matcher logLineMatcher = Pattern.compile(FULL_REGEX).matcher(logLineString);
        if (!logLineMatcher.matches()) {
            throw new IllegalArgumentException("Log line string does not match expected format: " + logLineString);
        }
        this.timestampOriginalString = logLineMatcher.group(1);
        this.timestamp = LogProcessingUtils.parseTimestamp(this.timestampOriginalString, zoneId);
        this.whitespaces.add(logLineMatcher.group(2));
        this.logNumber = logLineMatcher.group(3);
        this.whitespaces.add(logLineMatcher.group(4));
        this.logLevel = logLineMatcher.group(5);
        this.whitespaces.add(logLineMatcher.group(6));
        this.marker = logLineMatcher.group(7);
        this.whitespaces.add(logLineMatcher.group(8));
        this.threadName = logLineMatcher.group(9);
        this.whitespaces.add(logLineMatcher.group(10));
        this.className = logLineMatcher.group(11);
        this.colonSpace = logLineMatcher.group(12);
        String remainderString = logLineMatcher.group(13);
        switch (this.marker) {
            case "PLATFORM_STATUS": {
                this.remainderOfLine = new PlatformStatusLog(remainderString);
                break;
            }
            default: {
                this.remainderOfLine = new DefaultFormattableString(remainderString);
            }
        }
    }

    public LogLine(@NonNull String logLineString, @NonNull ZoneId zoneId) {
        this(logLineString, zoneId, null);
    }

    public void setLogStartTime(@NonNull Instant logStartTime) {
        this.logStartTime = Objects.requireNonNull(logStartTime);
    }

    public void addNonStandardLine(@NonNull String line) {
        if (this.additionalLines == null) {
            this.additionalLines = new NonStandardLog();
        }
        this.additionalLines.addLogText(line);
    }

    @Nullable
    public NodeId getNodeId() {
        return this.nodeId;
    }

    @NonNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @NonNull
    public String getLogNumber() {
        return this.logNumber;
    }

    @NonNull
    public String getLogLevel() {
        return this.logLevel;
    }

    @NonNull
    public String getMarker() {
        return this.marker;
    }

    @NonNull
    public String getThreadName() {
        return this.threadName;
    }

    @NonNull
    public String getClassName() {
        return this.className;
    }

    @NonNull
    public FormattableString getRemainderOfLine() {
        return this.remainderOfLine;
    }

    @Override
    @NonNull
    public String getOriginalPlaintext() {
        return this.originalLogString;
    }

    @Override
    @NonNull
    public String generateAnsiString() {
        int whitespaceIndex = 0;
        return TIMESTAMP_COLOR.apply(this.timestampOriginalString) + this.whitespaces.get(whitespaceIndex++) + LOG_NUMBER_COLOR.apply(this.logNumber) + this.whitespaces.get(whitespaceIndex++) + LogProcessingUtils.getLogLevelColor(this.logLevel).apply(this.logLevel) + this.whitespaces.get(whitespaceIndex++) + LOG_MARKER_COLOR.apply(this.marker) + this.whitespaces.get(whitespaceIndex++) + THREAD_NAME_COLOR.apply(this.threadName) + this.whitespaces.get(whitespaceIndex) + CLASS_NAME_COLOR.apply(this.className) + this.colonSpace + this.remainderOfLine.generateAnsiString();
    }

    @Override
    @NonNull
    public String generateHtmlString() {
        String elapsedTimeString;
        List<String> rowClassNames = Stream.of(this.logLevel, this.marker, this.threadName, this.className, this.nodeId == null ? "" : "node" + String.valueOf(this.nodeId), "hideable", "log-line").map(LogProcessingUtils::escapeString).toList();
        ArrayList<String> dataCellTags = new ArrayList<String>();
        String selectCheckbox = new HtmlTagFactory("input").addClass("select-checkbox").addClasses(rowClassNames).addAttribute("type", "checkbox").generateTag();
        HtmlTagFactory selectCheckboxCellFactory = new HtmlTagFactory("td", selectCheckbox);
        dataCellTags.add(selectCheckboxCellFactory.generateTag());
        HtmlTagFactory nodeIdTagFactory = new HtmlTagFactory("td", (String)(this.nodeId == null ? "" : "node" + LogProcessingUtils.escapeString(this.nodeId.toString()))).addClasses(List.of("node-id", "hideable", this.nodeId == null ? "" : "node-" + String.valueOf(this.nodeId))).addAttribute("blacklist", "0").addAttribute("whitelist", "0");
        dataCellTags.add(nodeIdTagFactory.generateTag());
        if (this.logStartTime == null) {
            elapsedTimeString = "";
        } else {
            UnitFormatter unitFormatter = new UnitFormatter(this.timestamp.toEpochMilli() - this.logStartTime.toEpochMilli(), (Unit)TimeUnit.UNIT_MILLISECONDS).setUnitFormat(UnitFormat.MULTI_SIMPLIFIED).setDecimalPlaces(3).setLowestUnit((Unit)TimeUnit.UNIT_SECONDS).setShowSpaceInBetween(false);
            elapsedTimeString = LogProcessingUtils.escapeString(unitFormatter.render());
        }
        HtmlTagFactory logStartTimeTagFactory = new HtmlTagFactory("td", elapsedTimeString).addClasses(List.of("elapsed-time", "hideable")).addAttribute("blacklist", "0").addAttribute("whitelist", "0");
        dataCellTags.add(logStartTimeTagFactory.generateTag());
        HtmlTagFactory timestampTagFactory = new HtmlTagFactory("td", LogProcessingUtils.escapeString(this.timestampOriginalString)).addClasses(List.of("timestamp", "hideable")).addAttribute("blacklist", "0").addAttribute("whitelist", "0");
        dataCellTags.add(timestampTagFactory.generateTag());
        HtmlTagFactory logNumberTagFactory = new HtmlTagFactory("td", LogProcessingUtils.escapeString(this.logNumber)).addClasses(List.of("log-number", "hideable")).addAttribute("blacklist", "0").addAttribute("whitelist", "0");
        dataCellTags.add(logNumberTagFactory.generateTag());
        HtmlTagFactory logLevelTagFactory = new HtmlTagFactory("td", LogProcessingUtils.escapeString(this.logLevel)).addClasses(List.of("log-level", "hideable", this.logLevel + "-level")).addAttribute("blacklist", "0").addAttribute("whitelist", "0");
        dataCellTags.add(logLevelTagFactory.generateTag());
        HtmlTagFactory markerTagFactory = new HtmlTagFactory("td", LogProcessingUtils.escapeString(this.marker)).addClasses(List.of("marker", "hideable")).addAttribute("blacklist", "0").addAttribute("whitelist", "0");
        dataCellTags.add(markerTagFactory.generateTag());
        HtmlTagFactory threadNameTagFactory = new HtmlTagFactory("td", LogProcessingUtils.escapeString(this.threadName)).addClasses(List.of("thread-name", "hideable")).addAttribute("blacklist", "0").addAttribute("whitelist", "0");
        dataCellTags.add(threadNameTagFactory.generateTag());
        HtmlTagFactory classNameTagFactory = new HtmlTagFactory("td", LogProcessingUtils.escapeString(this.className) + this.colonSpace).addClasses(List.of("class-name", "hideable")).addAttribute("blacklist", "0").addAttribute("whitelist", "0");
        dataCellTags.add(classNameTagFactory.generateTag());
        HtmlTagFactory remainderOfLineTagFactory = new HtmlTagFactory("td", this.remainderOfLine.generateHtmlString()).addClasses(List.of("remainder", "hideable")).addAttribute("blacklist", "0").addAttribute("whitelist", "0");
        dataCellTags.add(remainderOfLineTagFactory.generateTag());
        HtmlTagFactory mainLogRowFactory = new HtmlTagFactory("tr", "\n" + String.join((CharSequence)"\n", dataCellTags) + "\n").addClass("log-line");
        if (this.additionalLines == null) {
            mainLogRowFactory.addClasses(rowClassNames).addAttribute("blacklist", "0").addAttribute("whitelist", "0");
            return mainLogRowFactory.generateTag();
        }
        return new HtmlTagFactory("tbody", mainLogRowFactory.generateTag() + "\n" + this.additionalLines.generateHtmlString()).addClass("log-line").addClasses(rowClassNames).addAttribute("blacklist", "0").addAttribute("whitelist", "0").generateTag();
    }
}

