/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.blockstream.codec;

import com.hedera.hapi.node.state.blockstream.IncrementalStreamingSnapshot;
import com.hedera.hapi.node.state.blockstream.SubMerkleTree;
import com.hedera.hapi.node.state.blockstream.schema.IncrementalStreamingSnapshotSchema;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IncrementalStreamingSnapshotJsonCodec
implements JsonCodec<IncrementalStreamingSnapshot> {
    @NonNull
    public IncrementalStreamingSnapshot parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            SubMerkleTree temp_type = SubMerkleTree.fromProtobufOrdinal(0);
            List<Bytes> temp_nodes = Collections.emptyList();
            block10: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "type": {
                        temp_type = SubMerkleTree.fromString(kvPair.value().STRING().getText());
                        continue block10;
                    }
                    case "nodes": {
                        temp_nodes = JsonTools.checkSize((String)"nodes", (List)kvPair.value().arr().value(), (int)maxSize).stream().map(v -> Bytes.fromBase64((String)JsonTools.checkSize((String)"nodes", (String)v.STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)))).toList();
                        continue block10;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new IncrementalStreamingSnapshot(temp_type, temp_nodes);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull IncrementalStreamingSnapshot data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.type() != SubMerkleTree.fromProtobufOrdinal(0)) {
            fieldLines.add(JsonTools.field((String)"type", (String)data.type().protoName()));
        }
        if (!data.nodes().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"nodes", (FieldDefinition)IncrementalStreamingSnapshotSchema.NODES, data.nodes()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

