/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.concurrent.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.function.Supplier;
import org.hiero.base.concurrent.internal.DefaultForkJoinWorkerThread;
import org.hiero.base.concurrent.internal.DefaultThreadFactory;

public class DefaultForkJoinWorkerThreadFactory
implements ForkJoinPool.ForkJoinWorkerThreadFactory {
    public static final boolean PRESERVE_THREAD_LOCALS = true;
    private final ThreadGroup threadGroup;
    private final Supplier<String> threadNameFactory;
    private final Runnable onStartup;

    public DefaultForkJoinWorkerThreadFactory(@NonNull ThreadGroup threadGroup, @NonNull Supplier<String> threadNameFactory, @Nullable Runnable onStartup) {
        this.threadGroup = Objects.requireNonNull(threadGroup, "threadGroup must not be null");
        this.threadNameFactory = Objects.requireNonNull(threadNameFactory, "threadNameFactory must not be null");
        this.onStartup = onStartup;
    }

    @Override
    @NonNull
    public ForkJoinWorkerThread newThread(@NonNull ForkJoinPool pool) {
        return new DefaultForkJoinWorkerThread(this.threadNameFactory.get(), this.threadGroup, pool, true, this.onStartup);
    }

    @NonNull
    public static Supplier<String> createThreadNameFactory(@NonNull String threadNamePrefix) {
        return DefaultThreadFactory.createThreadNameFactory(threadNamePrefix);
    }
}

