/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.service.schemas;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.util.HapiUtils;
import com.swirlds.platform.state.service.WritablePlatformStateStore;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class V0640PlatformStateSchema
extends Schema<SemanticVersion> {
    private static final Logger LOGGER = LogManager.getLogger(V0640PlatformStateSchema.class);
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(64).patch(0).build();

    public V0640PlatformStateSchema() {
        super((Object)VERSION, HapiUtils.SEMANTIC_VERSION_COMPARATOR);
    }

    public void migrate(@NonNull MigrationContext ctx) {
        if (!ctx.isGenesis()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("V0640PlatformStateSchema - migrate() called during non-genesis state migration. Setting the last freeze round to the migration round number: {}", (Object)ctx.roundNumber());
            }
            WritablePlatformStateStore platformStateStore = new WritablePlatformStateStore(ctx.newStates());
            platformStateStore.setLatestFreezeRound(ctx.roundNumber());
        }
    }
}

