/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.extendable;

import com.swirlds.common.io.extendable.InputStreamExtension;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class ExtendableInputStream
extends InputStream {
    private final InputStream stream;
    private final InputStreamExtension extension;

    public static InputStream extendInputStream(InputStream stream, InputStreamExtension ... extensions) {
        if (extensions == null) {
            return stream;
        }
        InputStream s = stream;
        for (InputStreamExtension extension : extensions) {
            s = new ExtendableInputStream(s, extension);
        }
        return s;
    }

    public ExtendableInputStream(InputStream stream, InputStreamExtension extension) {
        this.stream = Objects.requireNonNull(stream, "stream must not be null");
        this.extension = Objects.requireNonNull(extension, "extension must not be null");
        extension.init(stream);
    }

    @Override
    public int read() throws IOException {
        return this.extension.read();
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        return this.extension.read(bytes, offset, length);
    }

    @Override
    public byte[] readNBytes(int length) throws IOException {
        return this.extension.readNBytes(length);
    }

    @Override
    public int readNBytes(byte[] bytes, int offset, int length) throws IOException {
        return this.extension.readNBytes(bytes, offset, length);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.stream.skip(n);
    }

    @Override
    public void skipNBytes(long n) throws IOException {
        this.stream.skipNBytes(n);
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        this.extension.close();
    }

    @Override
    public void mark(int readLimit) {
        this.stream.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public void reset() throws IOException {
        this.stream.reset();
    }
}

