/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.codec;

import com.hedera.hapi.block.stream.RedactedItem;
import com.hedera.hapi.node.state.blockstream.SubMerkleTree;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class RedactedItemJsonCodec
implements JsonCodec<RedactedItem> {
    @NonNull
    public RedactedItem parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            Bytes temp_item_hash = Bytes.EMPTY;
            Bytes temp_signed_transaction_hash = Bytes.EMPTY;
            SubMerkleTree temp_tree = SubMerkleTree.fromProtobufOrdinal(0);
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "itemHash": {
                        temp_item_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"item_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block12;
                    }
                    case "signedTransactionHash": {
                        temp_signed_transaction_hash = Bytes.fromBase64((String)JsonTools.checkSize((String)"signed_transaction_hash", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block12;
                    }
                    case "tree": {
                        temp_tree = SubMerkleTree.fromString(kvPair.value().STRING().getText());
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new RedactedItem(temp_item_hash, temp_signed_transaction_hash, temp_tree);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull RedactedItem data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.itemHash() != Bytes.EMPTY && data.itemHash() != null && data.itemHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"itemHash", (Bytes)data.itemHash()));
        }
        if (data.signedTransactionHash() != Bytes.EMPTY && data.signedTransactionHash() != null && data.signedTransactionHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"signedTransactionHash", (Bytes)data.signedTransactionHash()));
        }
        if (data.tree() != SubMerkleTree.fromProtobufOrdinal(0)) {
            fieldLines.add(JsonTools.field((String)"tree", (String)data.tree().protoName()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

