/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures;

import com.swirlds.common.test.fixtures.GaussianWeightGenerator;
import com.swirlds.common.test.fixtures.WeightGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hiero.base.utility.test.fixtures.RandomUtils;
import org.hiero.base.utility.test.fixtures.ResettableRandom;

public final class WeightGenerators {
    public static final long TOTAL_NETWORK_WEIGHT = 50000000000L;
    public static final WeightGenerator BALANCED = (l, i) -> WeightGenerators.balancedNodeWeights(i);
    public static final WeightGenerator BALANCED_1000_PER_NODE = (l, i) -> WeightGenerators.balancedNodeWeights(i, (long)i * 1000L);
    public static final WeightGenerator BALANCED_REAL_WEIGHT = (l, i) -> WeightGenerators.balancedNodeWeights(i, true);
    public static final WeightGenerator INCREMENTING = (l, i) -> WeightGenerators.incrementingWeight(i);
    public static final WeightGenerator SINGLE_NODE_STRONG_MINORITY = (l, i) -> WeightGenerators.singleNodeWithStrongMinority(i);
    public static final WeightGenerator ONE_THIRD_ZERO_WEIGHT = WeightGenerators::oneThirdNodesZeroWeight;
    public static final WeightGenerator RANDOM = WeightGenerators::randomNodeWeights;
    public static final WeightGenerator RANDOM_REAL_WEIGHT = (l, i) -> WeightGenerators.randomNodeWeights((Long)l, i, true);
    public static final WeightGenerator GAUSSIAN = GaussianWeightGenerator.withAverageNodeWeight(1000L, 100L);
    public static final WeightGenerator REAL_NETWORK_GAUSSIAN = GaussianWeightGenerator.withNetworkWeight(50000000000L, 100000L);
    private static final long MINIMUM_NON_ZERO_WEIGHT = 1L;
    private static final int EASY_TO_READ_WEIGHT = 90;

    private WeightGenerators() {
    }

    public static List<Long> balancedNodeWeights(int numberOfNodes) {
        return WeightGenerators.balancedNodeWeights(numberOfNodes, numberOfNodes);
    }

    public static List<Long> balancedNodeWeights(int numberOfNodes, boolean useRealTotalWeight) {
        if (useRealTotalWeight) {
            return WeightGenerators.balancedNodeWeights(numberOfNodes, 50000000000L);
        }
        return WeightGenerators.balancedNodeWeights(numberOfNodes);
    }

    public static List<Long> balancedNodeWeights(int numberOfNodes, long totalWeight) {
        long weightPerNode = totalWeight / (long)numberOfNodes;
        return Collections.nCopies(numberOfNodes, weightPerNode);
    }

    public static List<Long> randomNodeWeights(Long weightSeed, int numberOfNodes, boolean useRealTotalWeight) {
        if (useRealTotalWeight) {
            return WeightGenerators.randomNodeWeights((long)weightSeed, numberOfNodes, 50000000000L);
        }
        return WeightGenerators.randomNodeWeights(weightSeed, numberOfNodes);
    }

    public static List<Long> randomNodeWeights(long weightSeed, int numberOfNodes, long totalWeight) {
        ResettableRandom r = RandomUtils.initRandom((Long)weightSeed);
        ArrayList<Long> weights = new ArrayList<Long>(numberOfNodes);
        long halfTotalWeight = totalWeight / 2L;
        long firstNodeWeight = r.nextLong(halfTotalWeight);
        long remainingWeight = totalWeight - firstNodeWeight;
        weights.add(firstNodeWeight);
        for (int i = 1; i < numberOfNodes - 1; ++i) {
            long weight = r.nextLong(remainingWeight);
            remainingWeight -= weight;
            weights.add(weight);
        }
        weights.add(remainingWeight);
        return weights;
    }

    public static List<Long> randomNodeWeights(long weightSeed, int numberOfNodes) {
        ResettableRandom r = RandomUtils.initRandom((Long)weightSeed);
        ArrayList<Long> nodeWeights = new ArrayList<Long>(numberOfNodes);
        for (int i = 0; i < numberOfNodes; ++i) {
            nodeWeights.add(r.nextLong(1L, 90L));
        }
        return nodeWeights;
    }

    public static List<Long> oneThirdNodesZeroWeight(long weightSeed, int numberOfNodes) {
        ResettableRandom r = RandomUtils.initRandom((Long)weightSeed);
        ArrayList<Long> nodeWeights = new ArrayList<Long>(numberOfNodes);
        for (int nodeId = 0; nodeId < numberOfNodes; ++nodeId) {
            long weight = r.nextLong(1L, 90L);
            if (nodeId < numberOfNodes / 3) {
                weight = 0L;
            }
            nodeWeights.add(weight);
        }
        return nodeWeights;
    }

    public static List<Long> singleNodeWithStrongMinority(int numberOfNodes) {
        if (numberOfNodes < 3 || numberOfNodes > 61) {
            throw new IllegalArgumentException(String.format("Invalid number of nodes: %s. Valid range is 3 - 61 for this weight distribution.", numberOfNodes));
        }
        int totalWeight = 90;
        int strongMinorityWeight = 30;
        ArrayList<Long> nodeWeights = new ArrayList<Long>(numberOfNodes);
        for (int nodeId = 0; nodeId < numberOfNodes; ++nodeId) {
            long weight = 60 / (numberOfNodes - 1);
            if (nodeId == 0) {
                weight = 30L;
            }
            nodeWeights.add(weight);
        }
        return nodeWeights;
    }

    public static List<Long> incrementingWeight(int numberOfNodes) {
        ArrayList<Long> nodeWeights = new ArrayList<Long>(numberOfNodes);
        for (int nodeId = 0; nodeId < numberOfNodes; ++nodeId) {
            long weight = (long)nodeId + 1L;
            nodeWeights.add(weight);
        }
        return nodeWeights;
    }
}

