/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.concurrent.atomic.LongAdder;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.error.ShouldHaveValue;
import org.assertj.core.error.ShouldNotContainValue;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Longs;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public class AbstractLongAdderAssert<SELF extends AbstractLongAdderAssert<SELF>>
extends AbstractAssert<SELF, LongAdder>
implements NumberAssert<SELF, Long>,
ComparableAssert<SELF, Long> {
    @VisibleForTesting
    Longs longs = Longs.instance();

    protected AbstractLongAdderAssert(LongAdder longAdder, Class<?> selfType) {
        super(longAdder, selfType);
    }

    public SELF hasValue(long expected) {
        this.isNotNull();
        long actualValue = ((LongAdder)this.actual).sum();
        if (!this.objects.getComparisonStrategy().areEqual(actualValue, expected)) {
            this.throwAssertionError(ShouldHaveValue.shouldHaveValue(this.actual, expected));
        }
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    public SELF doesNotHaveValue(long unexpected) {
        this.isNotNull();
        long actualValue = ((LongAdder)this.actual).sum();
        if (this.objects.getComparisonStrategy().areEqual(actualValue, unexpected)) {
            this.throwAssertionError(ShouldNotContainValue.shouldNotContainValue(this.actual, unexpected));
        }
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super LongAdder> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super LongAdder> customComparator, String customComparatorDescription) {
        this.longs = new Longs(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractLongAdderAssert)super.usingComparator(customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.longs = Longs.instance();
        return (SELF)((AbstractLongAdderAssert)super.usingDefaultComparator());
    }

    @Override
    public SELF isZero() {
        this.longs.assertIsZero(this.info, ((LongAdder)this.actual).longValue());
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isNotZero() {
        this.longs.assertIsNotZero(this.info, ((LongAdder)this.actual).longValue());
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isOne() {
        this.longs.assertIsOne(this.info, ((LongAdder)this.actual).longValue());
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isPositive() {
        this.longs.assertIsPositive(this.info, ((LongAdder)this.actual).longValue());
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isNegative() {
        this.longs.assertIsNegative(this.info, ((LongAdder)this.actual).longValue());
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isNotNegative() {
        this.longs.assertIsNotNegative(this.info, ((LongAdder)this.actual).longValue());
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isNotPositive() {
        this.longs.assertIsNotPositive(this.info, ((LongAdder)this.actual).longValue());
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isEqualByComparingTo(Long other) {
        this.longs.assertEqualByComparison(this.info, Long.valueOf(((LongAdder)this.actual).longValue()), other);
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isNotEqualByComparingTo(Long other) {
        this.longs.assertNotEqualByComparison(this.info, Long.valueOf(((LongAdder)this.actual).longValue()), other);
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isLessThan(Long other) {
        this.longs.assertLessThan(this.info, Long.valueOf(((LongAdder)this.actual).longValue()), other);
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isLessThanOrEqualTo(Long other) {
        this.longs.assertLessThanOrEqualTo(this.info, Long.valueOf(((LongAdder)this.actual).longValue()), other);
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isGreaterThan(Long other) {
        this.longs.assertGreaterThan(this.info, Long.valueOf(((LongAdder)this.actual).longValue()), other);
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isGreaterThanOrEqualTo(Long other) {
        this.longs.assertGreaterThanOrEqualTo(this.info, Long.valueOf(((LongAdder)this.actual).longValue()), other);
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isBetween(Long start, Long end) {
        this.longs.assertIsBetween(this.info, ((LongAdder)this.actual).longValue(), start, end);
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isStrictlyBetween(Long start, Long end) {
        this.longs.assertIsStrictlyBetween(this.info, ((LongAdder)this.actual).longValue(), start, end);
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Long expected, Offset<Long> offset) {
        this.longs.assertIsCloseTo(this.info, ((LongAdder)this.actual).longValue(), expected, offset);
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Long expected, Offset<Long> offset) {
        this.longs.assertIsNotCloseTo(this.info, ((LongAdder)this.actual).longValue(), expected, offset);
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Long expected, Percentage percentage) {
        this.longs.assertIsCloseToPercentage(this.info, ((LongAdder)this.actual).longValue(), expected, percentage);
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Long expected, Percentage percentage) {
        this.longs.assertIsNotCloseToPercentage(this.info, ((LongAdder)this.actual).longValue(), expected, percentage);
        return (SELF)((AbstractLongAdderAssert)this.myself);
    }
}

