/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.map.smartcontracts.data;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.virtualmap.VirtualKey;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class SmartContractMapKey
implements VirtualKey {
    private static final long CLASS_ID = 3990313982995314210L;
    private long contractId;
    private long keyValuePairIndex;

    public SmartContractMapKey() {
        this(0L, 0L);
    }

    public SmartContractMapKey(long contractId, long keyValuePairIndex) {
        this.contractId = contractId;
        this.keyValuePairIndex = keyValuePairIndex;
    }

    public Bytes toBytes() {
        byte[] bytes = new byte[16];
        ByteBuffer.wrap(bytes).putLong(this.contractId).putLong(this.keyValuePairIndex);
        return Bytes.wrap((byte[])bytes);
    }

    public long getClassId() {
        return 3990313982995314210L;
    }

    public int getVersion() {
        return 1;
    }

    boolean equals(BufferedData buffer) {
        return this.contractId == buffer.readLong() && this.keyValuePairIndex == buffer.readLong();
    }

    static int getSizeInBytes() {
        return 16;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.contractId);
        out.writeLong(this.keyValuePairIndex);
    }

    void serialize(WritableSequentialData out) {
        out.writeLong(this.contractId);
        out.writeLong(this.keyValuePairIndex);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.contractId = in.readLong();
        this.keyValuePairIndex = in.readLong();
    }

    void deserialize(ReadableSequentialData in) {
        this.contractId = in.readLong();
        this.keyValuePairIndex = in.readLong();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SmartContractMapKey that = (SmartContractMapKey)other;
        return this.contractId == that.contractId && this.keyValuePairIndex == that.keyValuePairIndex;
    }

    public int hashCode() {
        return Objects.hash(this.contractId, this.keyValuePairIndex);
    }

    public String toString() {
        return "SmartContractMapKey{contractId=" + this.contractId + ", keyValuePairIndex=" + this.keyValuePairIndex + "}";
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

