/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import java.util.BitSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;

final class ConcurrentBitSetQueue {
    private static final int LIMIT = 0x40000000;
    private static final int RIGHT_SHIFTS_FOR_LIMIT_AS_DIVISOR = 30;
    private static final int DIVISOR = 0x3FFFFFFF;
    private final ConcurrentLinkedDeque<BitSetNode> bitsets;
    private final AtomicLong size = new AtomicLong();
    private long previousBitIndex = -1L;
    private long indexForRemoval = 0L;

    ConcurrentBitSetQueue() {
        this.bitsets = new ConcurrentLinkedDeque();
    }

    void add(long value) {
        BitSetNode bitSetNode;
        if (value <= this.previousBitIndex) {
            throw new IllegalArgumentException("Each value added must be strictly greater than the one before it");
        }
        int index = ConcurrentBitSetQueue.getIndexInBitSetFor(value);
        long bitSetIndex = ConcurrentBitSetQueue.getBitSetIndexFor(value);
        long offset = bitSetIndex * 0x40000000L;
        if (this.bitsets.isEmpty() || this.bitsets.peekLast().offset != offset) {
            bitSetNode = new BitSetNode(offset, new BitSet(0x40000000));
            this.bitsets.add(bitSetNode);
        } else {
            bitSetNode = this.bitsets.peekLast();
        }
        BitSet bitSet = bitSetNode.bitSet;
        bitSet.set(index);
        this.previousBitIndex = value;
        this.size.incrementAndGet();
    }

    long remove() {
        if (this.isEmpty()) {
            throw new IllegalStateException("BitSetQueue is empty");
        }
        int index = ConcurrentBitSetQueue.getIndexInBitSetFor(this.indexForRemoval);
        BitSetNode bitSetNode = this.bitsets.peek();
        assert (bitSetNode != null);
        if (bitSetNode.offsetEnd <= this.indexForRemoval || bitSetNode.bitSet.nextSetBit(index) < 0) {
            this.bitsets.remove();
            bitSetNode = this.bitsets.peek();
            assert (bitSetNode != null);
            index = 0;
        }
        BitSet bitSet = bitSetNode.bitSet;
        int setIndex = bitSet.nextSetBit(index);
        long value = bitSetNode.offset + (long)setIndex;
        this.indexForRemoval = value + 1L;
        this.size.decrementAndGet();
        return value;
    }

    boolean isEmpty() {
        return this.size() == 0L;
    }

    long size() {
        return this.size.get();
    }

    static long getBitSetIndexFor(long value) {
        return value >> 30;
    }

    static int getIndexInBitSetFor(long value) {
        return (int)(value & 0x3FFFFFFFL);
    }

    private static final class BitSetNode {
        private final BitSet bitSet;
        private final long offset;
        private final long offsetEnd;

        private BitSetNode(long offset, BitSet bitset) {
            this.offset = offset;
            this.bitSet = bitset;
            this.offsetEnd = offset + 0x40000000L;
        }
    }
}

