/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gossip;

import com.google.common.collect.ImmutableList;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.threading.pool.CachedPoolParallelExecutor;
import com.swirlds.common.threading.pool.ParallelExecutor;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.wires.input.BindableInputWire;
import com.swirlds.component.framework.wires.output.StandardOutputWire;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.Utilities;
import com.swirlds.platform.gossip.IntakeEventCounter;
import com.swirlds.platform.gossip.ProtocolConfig;
import com.swirlds.platform.gossip.shadowgraph.AbstractShadowgraphSynchronizer;
import com.swirlds.platform.gossip.shadowgraph.RpcShadowgraphSynchronizer;
import com.swirlds.platform.gossip.shadowgraph.Shadowgraph;
import com.swirlds.platform.gossip.shadowgraph.ShadowgraphSynchronizer;
import com.swirlds.platform.metrics.ReconnectMetrics;
import com.swirlds.platform.metrics.SyncMetrics;
import com.swirlds.platform.network.PeerCommunication;
import com.swirlds.platform.network.PeerInfo;
import com.swirlds.platform.network.communication.handshake.VersionCompareHandshake;
import com.swirlds.platform.network.protocol.AbstractSyncProtocol;
import com.swirlds.platform.network.protocol.HeartbeatProtocol;
import com.swirlds.platform.network.protocol.Protocol;
import com.swirlds.platform.network.protocol.ProtocolRunnable;
import com.swirlds.platform.network.protocol.ReconnectStateSyncProtocol;
import com.swirlds.platform.network.protocol.ReservedSignedStateResultPromise;
import com.swirlds.platform.network.protocol.SyncProtocol;
import com.swirlds.platform.network.protocol.rpc.RpcProtocol;
import com.swirlds.platform.reconnect.FallenBehindMonitor;
import com.swirlds.platform.reconnect.ReconnectStateTeacherThrottle;
import com.swirlds.platform.state.SwirldStateManager;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.wiring.NoInput;
import com.swirlds.platform.wiring.components.Gossip;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.CryptoUtils;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.roster.RosterUtils;

public class SyncGossipModular
implements Gossip {
    private static final Logger logger = LogManager.getLogger(SyncGossipModular.class);
    private final PeerCommunication network;
    private final ImmutableList<Protocol> protocols;
    private final AbstractSyncProtocol<?> syncProtocol;
    private final FallenBehindMonitor fallenBehindMonitor;
    private final AbstractShadowgraphSynchronizer synchronizer;
    private final SwirldStateManager swirldStateManager;
    private final Function<VirtualMap, MerkleNodeState> createStateFromVirtualMap;
    private Consumer<PlatformEvent> receivedEventHandler;
    private Consumer<Double> syncLagHandler;

    public SyncGossipModular(@NonNull PlatformContext platformContext, @NonNull ThreadManager threadManager, @NonNull KeysAndCerts ownKeysAndCerts, @NonNull Roster roster, @NonNull NodeId selfId, @NonNull SemanticVersion appVersion, @NonNull SwirldStateManager swirldStateManager, @NonNull Supplier<ReservedSignedState> latestCompleteState, @NonNull IntakeEventCounter intakeEventCounter, @NonNull PlatformStateFacade platformStateFacade, @NonNull Function<VirtualMap, MerkleNodeState> createStateFromVirtualMap, @NonNull FallenBehindMonitor fallenBehindMonitor, @NonNull ReservedSignedStateResultPromise reservedSignedStateResultPromise) {
        List<PeerInfo> peers;
        RosterEntry selfEntry = RosterUtils.getRosterEntry((Roster)roster, (long)selfId.id());
        X509Certificate selfCert = RosterUtils.fetchGossipCaCertificate((RosterEntry)selfEntry);
        if (!CryptoUtils.checkCertificate((Certificate)selfCert)) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "The gossip certificate for node {} is missing or invalid. This node will not connect to any peers.", (Object)selfId);
            peers = Collections.emptyList();
        } else {
            peers = Utilities.createPeerInfoList(roster, selfId);
        }
        PeerInfo selfPeer = Utilities.toPeerInfo(selfEntry);
        this.network = new PeerCommunication(platformContext, peers, selfPeer, ownKeysAndCerts);
        this.fallenBehindMonitor = fallenBehindMonitor;
        this.swirldStateManager = swirldStateManager;
        this.createStateFromVirtualMap = createStateFromVirtualMap;
        ProtocolConfig protocolConfig = (ProtocolConfig)platformContext.getConfiguration().getConfigData(ProtocolConfig.class);
        int rosterSize = peers.size() + 1;
        SyncMetrics syncMetrics = new SyncMetrics(platformContext.getMetrics(), platformContext.getTime());
        if (protocolConfig.rpcGossip()) {
            RpcShadowgraphSynchronizer rpcSynchronizer = new RpcShadowgraphSynchronizer(platformContext, rosterSize, syncMetrics, event -> this.receivedEventHandler.accept((PlatformEvent)event), this.fallenBehindMonitor, intakeEventCounter, selfId, lag -> this.syncLagHandler.accept((Double)lag));
            this.synchronizer = rpcSynchronizer;
            this.syncProtocol = RpcProtocol.create(platformContext, rpcSynchronizer, intakeEventCounter, threadManager, rosterSize, this.network.getNetworkMetrics(), syncMetrics);
        } else {
            Shadowgraph shadowgraph = new Shadowgraph(platformContext, rosterSize, intakeEventCounter);
            ShadowgraphSynchronizer shadowgraphSynchronizer = new ShadowgraphSynchronizer(platformContext, shadowgraph, rosterSize, syncMetrics, event -> this.receivedEventHandler.accept((PlatformEvent)event), this.fallenBehindMonitor, intakeEventCounter, (ParallelExecutor)new CachedPoolParallelExecutor(threadManager, "node-sync"), lag -> this.syncLagHandler.accept((Double)lag));
            this.synchronizer = shadowgraphSynchronizer;
            this.syncProtocol = SyncProtocol.create(platformContext, shadowgraphSynchronizer, this.fallenBehindMonitor, intakeEventCounter, rosterSize, syncMetrics);
        }
        ReconnectStateSyncProtocol reconnectStateSyncProtocol = this.createStateSyncProtocol(platformContext, threadManager, latestCompleteState, platformStateFacade, reservedSignedStateResultPromise);
        this.protocols = ImmutableList.of((Object)HeartbeatProtocol.create(platformContext, this.network.getNetworkMetrics()), (Object)reconnectStateSyncProtocol, this.syncProtocol);
        VersionCompareHandshake versionCompareHandshake = new VersionCompareHandshake(appVersion, !protocolConfig.tolerateMismatchedVersion());
        List<ProtocolRunnable> handshakeProtocols = List.of(versionCompareHandshake);
        this.network.initialize(threadManager, handshakeProtocols, (List<Protocol>)this.protocols);
    }

    public ReconnectStateSyncProtocol createStateSyncProtocol(@NonNull PlatformContext platformContext, @NonNull ThreadManager threadManager, @NonNull Supplier<ReservedSignedState> latestCompleteState, @NonNull PlatformStateFacade platformStateFacade, @NonNull ReservedSignedStateResultPromise reservedSignedStateResultPromise) {
        ReconnectConfig reconnectConfig = (ReconnectConfig)platformContext.getConfiguration().getConfigData(ReconnectConfig.class);
        ReconnectStateTeacherThrottle reconnectStateTeacherThrottle = new ReconnectStateTeacherThrottle(reconnectConfig, platformContext.getTime());
        ReconnectMetrics reconnectMetrics = new ReconnectMetrics(platformContext.getMetrics());
        return new ReconnectStateSyncProtocol(platformContext, threadManager, reconnectStateTeacherThrottle, latestCompleteState, reconnectConfig.asyncStreamTimeout(), reconnectMetrics, this.fallenBehindMonitor, platformStateFacade, reservedSignedStateResultPromise, this.swirldStateManager, this.createStateFromVirtualMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemovePeers(@NonNull List<PeerInfo> added, @NonNull List<PeerInfo> removed) {
        SyncGossipModular syncGossipModular = this;
        synchronized (syncGossipModular) {
            this.syncProtocol.adjustTotalPermits(added.size() - removed.size());
            this.network.addRemovePeers(added, removed);
        }
    }

    @Override
    public void bind(@NonNull WiringModel model, @NonNull BindableInputWire<PlatformEvent, Void> eventInput, @NonNull BindableInputWire<EventWindow, Void> eventWindowInput, @NonNull StandardOutputWire<PlatformEvent> eventOutput, @NonNull BindableInputWire<NoInput, Void> startInput, @NonNull BindableInputWire<NoInput, Void> stopInput, @NonNull BindableInputWire<NoInput, Void> clearInput, @NonNull BindableInputWire<NoInput, Void> pauseGossip, @NonNull BindableInputWire<NoInput, Void> resumeGossip, @NonNull BindableInputWire<Duration, Void> systemHealthInput, @NonNull BindableInputWire<PlatformStatus, Void> platformStatusInput, @NonNull StandardOutputWire<Double> syncLagOutput) {
        startInput.bindConsumer(ignored -> {
            this.syncProtocol.start();
            this.network.start();
        });
        stopInput.bindConsumer(ignored -> {
            this.syncProtocol.stop();
            this.network.stop();
        });
        clearInput.bindConsumer(ignored -> this.syncProtocol.clear());
        eventInput.bindConsumer(this.synchronizer::addEvent);
        eventWindowInput.bindConsumer(this.synchronizer::updateEventWindow);
        systemHealthInput.bindConsumer(this.syncProtocol::reportUnhealthyDuration);
        platformStatusInput.bindConsumer(status -> this.protocols.forEach(protocol -> protocol.updatePlatformStatus((PlatformStatus)status)));
        pauseGossip.bindConsumer(ignored -> this.syncProtocol.pause());
        resumeGossip.bindConsumer(ignored -> this.syncProtocol.resume());
        this.receivedEventHandler = arg_0 -> eventOutput.forward(arg_0);
        this.syncLagHandler = arg_0 -> syncLagOutput.forward(arg_0);
    }
}

