/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.rules;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.function.Supplier;
import org.hiero.consensus.event.creator.impl.EventCreationStatus;
import org.hiero.consensus.event.creator.impl.rules.EventCreationRule;

public class SyncLagRule
implements EventCreationRule {
    private final int maxAllowedSyncLag;
    private final Supplier<Double> getSyncRoundLag;

    public SyncLagRule(int maxAllowedSyncLag, Supplier<Double> getSyncRoundLag) {
        this.maxAllowedSyncLag = maxAllowedSyncLag;
        this.getSyncRoundLag = getSyncRoundLag;
    }

    @Override
    public boolean isEventCreationPermitted() {
        return this.getSyncRoundLag.get() < (double)this.maxAllowedSyncLag;
    }

    @Override
    public void eventWasCreated() {
    }

    @Override
    @NonNull
    public EventCreationStatus getEventCreationStatus() {
        return EventCreationStatus.ROUND_LAG;
    }
}

