/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.block.api;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.GrpcCall;
import com.hedera.pbj.runtime.grpc.GrpcClient;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import org.hiero.block.api.StateSnapshotRequest;
import org.hiero.block.api.StateSnapshotResponse;

public interface StateServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "StateService";
    public static final String FULL_NAME = "org.hiero.block.api.StateService";

    @NonNull
    public StateSnapshotResponse stateSnapshot(@NonNull StateSnapshotRequest var1);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(StateServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        StateServiceMethod m = (StateServiceMethod)method;
        try {
            switch (m.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
            }
            return Pipelines.unary().mapRequest(bytes -> StateServiceInterface.parseStateSnapshotRequest(bytes, options)).method(this::stateSnapshot).mapResponse(reply -> StateServiceInterface.serializeStateSnapshotResponse(reply, options)).respondTo(replies).build();
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private static Codec<StateSnapshotRequest> getStateSnapshotRequestCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return StateSnapshotRequest.JSON;
        }
        return StateSnapshotRequest.PROTOBUF;
    }

    @NonNull
    private static Codec<StateSnapshotResponse> getStateSnapshotResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return StateSnapshotResponse.JSON;
        }
        return StateSnapshotResponse.PROTOBUF;
    }

    @NonNull
    private static StateSnapshotRequest parseStateSnapshotRequest(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (StateSnapshotRequest)StateServiceInterface.getStateSnapshotRequestCodec(options).parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private static Bytes serializeStateSnapshotResponse(@NonNull StateSnapshotResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return StateServiceInterface.getStateSnapshotResponseCodec(options).toBytes((Object)reply);
    }

    public static enum StateServiceMethod implements ServiceInterface.Method
    {
        stateSnapshot;

    }

    public static class StateServiceClient
    implements StateServiceInterface {
        private final GrpcClient grpcClient;
        private final ServiceInterface.RequestOptions requestOptions;

        public StateServiceClient(@NonNull GrpcClient grpcClient, @NonNull ServiceInterface.RequestOptions requestOptions) {
            this.grpcClient = Objects.requireNonNull(grpcClient);
            this.requestOptions = Objects.requireNonNull(requestOptions);
        }

        public void close() {
            this.grpcClient.close();
        }

        @Override
        @NonNull
        public StateSnapshotResponse stateSnapshot(@NonNull StateSnapshotRequest request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<StateSnapshotResponse> pipeline = new Pipeline<StateSnapshotResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(StateSnapshotResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("stateSnapshot is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("org.hiero.block.api.StateService/stateSnapshot", StateServiceInterface.getStateSnapshotRequestCodec(this.requestOptions), StateServiceInterface.getStateSnapshotResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (StateSnapshotResponse)replyRef.get();
            }
            throw new RuntimeException("Call to stateSnapshot completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }
    }
}

