/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HookCall;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class AccountAmountJsonCodec
implements JsonCodec<AccountAmount> {
    public static final OneOf<AccountAmount.HookCallOneOfType> HOOK_CALL_UNSET = new OneOf((Enum)AccountAmount.HookCallOneOfType.UNSET, null);

    @NonNull
    public AccountAmount parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            AccountID temp_accountID = null;
            long temp_amount = 0L;
            boolean temp_is_approval = false;
            OneOf temp_hook_call = HOOK_CALL_UNSET;
            block16: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "accountID": {
                        temp_accountID = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block16;
                    }
                    case "amount": {
                        temp_amount = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block16;
                    }
                    case "isApproval": {
                        temp_is_approval = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block16;
                    }
                    case "preTxAllowanceHook": {
                        temp_hook_call = new OneOf((Enum)AccountAmount.HookCallOneOfType.PRE_TX_ALLOWANCE_HOOK, HookCall.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block16;
                    }
                    case "prePostTxAllowanceHook": {
                        temp_hook_call = new OneOf((Enum)AccountAmount.HookCallOneOfType.PRE_POST_TX_ALLOWANCE_HOOK, HookCall.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize));
                        continue block16;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new AccountAmount(temp_accountID, temp_amount, temp_is_approval, temp_hook_call);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull AccountAmount data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.accountID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"accountID", AccountID.JSON, (Object)data.accountID()));
        }
        if (data.amount() != 0L) {
            fieldLines.add(JsonTools.field((String)"amount", (long)data.amount()));
        }
        if (data.isApproval()) {
            fieldLines.add(JsonTools.field((String)"isApproval", (boolean)data.isApproval()));
        }
        if (data.hookCall().kind() == AccountAmount.HookCallOneOfType.PRE_TX_ALLOWANCE_HOOK) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"preTxAllowanceHook", HookCall.JSON, (Object)data.preTxAllowanceHook()));
        }
        if (data.hookCall().kind() == AccountAmount.HookCallOneOfType.PRE_POST_TX_ALLOWANCE_HOOK) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"prePostTxAllowanceHook", HookCall.JSON, (Object)data.prePostTxAllowanceHook()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

