/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.extensions.test.fixtures;

import com.swirlds.config.api.ConfigData;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class ConfigUtils {
    private ConfigUtils() {
    }

    @NonNull
    public static Set<Class<? extends Record>> loadAllConfigDataRecords(@NonNull Set<String> packagePrefixes) {
        Objects.requireNonNull(packagePrefixes, "packagePrefix must not be null");
        ClassGraph classGraph = new ClassGraph().enableAnnotationInfo();
        if (!packagePrefixes.isEmpty()) {
            classGraph.whitelistPackages(packagePrefixes.toArray(new String[0]));
        }
        try (ScanResult result = classGraph.scan();){
            ClassInfoList classInfos = result.getClassesWithAnnotation(ConfigData.class.getName());
            Set<Class<? extends Record>> set = classInfos.stream().map(ClassInfo::loadClass).filter(Class::isRecord).map(clazz -> clazz).collect(Collectors.toSet());
            return set;
        }
    }
}

