/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.merkle.util;

import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.LearningSynchronizer;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.test.fixtures.merkle.TestMerkleCryptoFactory;
import com.swirlds.common.test.fixtures.merkle.util.LaggingAsyncOutputStream;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.common.threading.pool.StandardWorkGroup;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class LaggingLearningSynchronizer
extends LearningSynchronizer {
    private final int latencyMilliseconds;

    public LaggingLearningSynchronizer(MerkleDataInputStream in, MerkleDataOutputStream out, MerkleNode root, int latencyMilliseconds, Runnable breakConnection, ReconnectConfig reconnectConfig, @NonNull Metrics metrics) {
        super(AdHocThreadManager.getStaticThreadManager(), in, out, root, breakConnection, TestMerkleCryptoFactory.getInstance(), reconnectConfig, metrics);
        this.latencyMilliseconds = latencyMilliseconds;
    }

    public <T extends SelfSerializable> AsyncOutputStream<T> buildOutputStream(StandardWorkGroup workGroup, SerializableDataOutputStream out) {
        return new LaggingAsyncOutputStream(out, workGroup, this.latencyMilliseconds, this.reconnectConfig);
    }
}

