/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures;

import com.swirlds.state.spi.ReadableQueueStateBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;

public class ListReadableQueueState<E>
extends ReadableQueueStateBase<E> {
    private final Queue<E> backingStore;

    public ListReadableQueueState(int stateId, String label, @NonNull Queue<E> backingStore) {
        super(stateId, label);
        this.backingStore = Objects.requireNonNull(backingStore);
    }

    @Nullable
    protected E peekOnDataSource() {
        return this.backingStore.peek();
    }

    @NonNull
    protected Iterator<E> iterateOnDataSource() {
        return this.backingStore.iterator();
    }

    @NonNull
    public static <E> Builder<E> builder(int stateId, @NonNull String label) {
        return new Builder(stateId, label);
    }

    public static final class Builder<E> {
        private final int stateId;
        private final String label;
        private final Queue<E> backingStore = new LinkedList();

        Builder(int stateId, @NonNull String label) {
            this.stateId = stateId;
            this.label = label;
        }

        @NonNull
        public Builder<E> value(@NonNull E element) {
            this.backingStore.add(element);
            return this;
        }

        @NonNull
        public ListReadableQueueState<E> build() {
            return new ListReadableQueueState<E>(this.stateId, this.label, new LinkedList<E>(this.backingStore));
        }
    }
}

