/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto.internal;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.KeyPair;
import org.hiero.base.crypto.BytesSigner;
import org.hiero.consensus.crypto.internal.SodiumJni;

public class SodiumSigner
implements BytesSigner {
    private final byte[] sodiumSecretKey;

    public SodiumSigner(@NonNull KeyPair keyPair) {
        if (!keyPair.getPrivate().getAlgorithm().equals("EdDSA")) {
            throw new IllegalArgumentException("SodiumSigner only supports EdDSA keys, the supplied key is of type: " + keyPair.getPrivate().getAlgorithm());
        }
        this.sodiumSecretKey = new byte[64];
        byte[] privateEncoded = keyPair.getPrivate().getEncoded();
        System.arraycopy(privateEncoded, privateEncoded.length - 32, this.sodiumSecretKey, 0, 32);
        byte[] publicEncoded = keyPair.getPublic().getEncoded();
        System.arraycopy(publicEncoded, publicEncoded.length - 32, this.sodiumSecretKey, 32, 32);
    }

    @NonNull
    public Bytes sign(@NonNull Bytes data) {
        byte[] signature = new byte[64];
        boolean signed = SodiumJni.SODIUM.cryptoSignDetached(signature, data.toByteArray(), data.length(), this.sodiumSecretKey);
        if (!signed) {
            throw new RuntimeException("Failed to sign data using Ed25519 with Sodium");
        }
        return Bytes.wrap((byte[])signature);
    }
}

