/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Map;
import org.hiero.base.crypto.BytesSignatureVerifier;
import org.hiero.base.crypto.BytesSigner;
import org.hiero.base.crypto.CryptographyException;
import org.hiero.consensus.crypto.SigningImplementation;
import org.hiero.consensus.crypto.SigningSchema;
import org.hiero.consensus.crypto.internal.JcaSigner;
import org.hiero.consensus.crypto.internal.JcaVerifier;
import org.hiero.consensus.crypto.internal.SodiumSigner;
import org.hiero.consensus.crypto.internal.SodiumVerifier;

public final class SigningFactory {
    private static final Map<String, SigningImplementation> defaultImplementations = Map.of(SigningSchema.RSA.getKeyType(), SigningImplementation.RSA_BC, SigningSchema.EC.getKeyType(), SigningImplementation.EC_JDK, SigningSchema.ED25519.getKeyType(), SigningImplementation.ED25519_SODIUM);

    private SigningFactory() {
    }

    @NonNull
    public static KeyPair generateKeyPair(@NonNull SigningSchema signingSchema, @NonNull SecureRandom secureRandom) {
        KeyPairGenerator keyPairGen;
        try {
            keyPairGen = KeyPairGenerator.getInstance(signingSchema.getKeyType());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException((Throwable)e);
        }
        keyPairGen.initialize(signingSchema.getKeySizeBits(), secureRandom);
        return keyPairGen.generateKeyPair();
    }

    @NonNull
    public static BytesSigner createSigner(@NonNull KeyPair keyPair) {
        SigningImplementation implementation = defaultImplementations.get(keyPair.getPrivate().getAlgorithm());
        if (implementation == null) {
            throw new IllegalArgumentException("No implementation for key type: " + keyPair.getPrivate().getAlgorithm());
        }
        return SigningFactory.createSigner(implementation, keyPair);
    }

    @NonNull
    public static BytesSigner createSigner(@NonNull SigningImplementation signType, @NonNull KeyPair keyPair) {
        if (signType == SigningImplementation.ED25519_SODIUM) {
            return new SodiumSigner(keyPair);
        }
        return new JcaSigner(keyPair.getPrivate(), signType.getSigningSchema().getSigningAlgorithm(), signType.getProvider());
    }

    @NonNull
    public static BytesSignatureVerifier createVerifier(@NonNull KeyPair keyPair) {
        SigningImplementation implementation = defaultImplementations.get(keyPair.getPublic().getAlgorithm());
        if (implementation == null) {
            throw new IllegalArgumentException("No implementation for key type: " + keyPair.getPublic().getAlgorithm());
        }
        return SigningFactory.createVerifier(implementation, keyPair.getPublic());
    }

    @NonNull
    public static BytesSignatureVerifier createVerifier(@NonNull SigningImplementation signType, @NonNull PublicKey publicKey) {
        if (signType == SigningImplementation.ED25519_SODIUM) {
            return new SodiumVerifier(publicKey);
        }
        return new JcaVerifier(publicKey, signType.getSigningSchema().getSigningAlgorithm(), signType.getProvider());
    }
}

