/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.snapshot;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.merkle.utility.MerkleTreeVisualizer;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.StateSavedToDiskPayload;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.config.internal.PlatformConfigUtils;
import com.swirlds.platform.event.preconsensus.BestEffortPcesFileCopy;
import com.swirlds.platform.recovery.emergencyfile.EmergencyRecoveryFile;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.snapshot.SavedStateMetadata;
import com.swirlds.platform.state.snapshot.StateToDiskReason;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.StateLifecycleManager;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.io.SelfSerializable;
import org.hiero.consensus.model.node.NodeId;

public final class SignedStateFileWriter {
    private static final Logger logger = LogManager.getLogger(SignedStateFileWriter.class);

    private SignedStateFileWriter() {
    }

    public static void writeHashInfoFile(@NonNull PlatformContext platformContext, @NonNull Path directory, @NonNull MerkleNodeState state, @NonNull PlatformStateFacade platformStateFacade) throws IOException {
        StateConfig stateConfig = (StateConfig)platformContext.getConfiguration().getConfigData(StateConfig.class);
        String platformInfo = platformStateFacade.getInfoString((State)state, stateConfig.debugHashDepth());
        logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Information for state written to disk:\n{}", (Object)platformInfo);
        Path hashInfoFile = directory.resolve("hashInfo.txt");
        String hashInfo = new MerkleTreeVisualizer(state.getRoot()).setDepth(stateConfig.debugHashDepth()).render();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(hashInfoFile.toFile()));){
            writer.write(hashInfo);
        }
    }

    private static void writeMetadataFile(@Nullable NodeId selfId, @NonNull Path directory, @NonNull SignedState signedState, @NonNull PlatformStateFacade platformStateFacade) throws IOException {
        Objects.requireNonNull(directory, "directory must not be null");
        Objects.requireNonNull(signedState, "signedState must not be null");
        Path metadataFile = directory.resolve("stateMetadata.txt");
        SavedStateMetadata.create(signedState, selfId, Instant.now(), platformStateFacade).write(metadataFile);
    }

    private static void writeSignatureSetToStream(MerkleDataOutputStream out, SignedState signedState) throws IOException {
        out.writeInt(1);
        out.writeProtocolVersion();
        out.writeSerializable((SelfSerializable)signedState.getSigSet(), true);
    }

    public static void writeSignatureSetFile(@NonNull Path directory, @NonNull SignedState signedState) throws IOException {
        FileUtils.writeAndFlush((Path)directory.resolve("signatureSet.bin"), out -> SignedStateFileWriter.writeSignatureSetToStream(out, signedState));
    }

    public static void writeSignedStateFilesToDirectory(@Nullable PlatformContext platformContext, @Nullable NodeId selfId, @NonNull Path directory, @NonNull SignedState signedState, @NonNull PlatformStateFacade platformStateFacade, @NonNull StateLifecycleManager stateLifecycleManager) throws IOException {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(directory);
        Objects.requireNonNull(signedState);
        Objects.requireNonNull(platformStateFacade);
        Objects.requireNonNull(stateLifecycleManager);
        stateLifecycleManager.createSnapshot(signedState.getState(), directory);
        SignedStateFileWriter.writeSignatureSetFile(directory, signedState);
        SignedStateFileWriter.writeHashInfoFile(platformContext, directory, signedState.getState(), platformStateFacade);
        SignedStateFileWriter.writeMetadataFile(selfId, directory, signedState, platformStateFacade);
        SignedStateFileWriter.writeEmergencyRecoveryFile(directory, signedState);
        Roster currentRoster = signedState.getRoster();
        SignedStateFileWriter.writeRosterFile(directory, currentRoster);
        PlatformConfigUtils.writeSettingsUsed(directory, platformContext.getConfiguration());
        if (selfId != null) {
            BestEffortPcesFileCopy.copyPcesFilesRetryOnFailure(platformContext, selfId, directory, platformStateFacade.ancientThresholdOf((State)signedState.getState()), signedState.getRound());
        }
    }

    private static void writeRosterFile(@NonNull Path directory, @NonNull Roster roster) throws IOException {
        Path rosterFile = directory.resolve("currentRoster.json");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(rosterFile.toFile()));){
            writer.write(Roster.JSON.toJSON((Object)roster));
        }
    }

    public static void writeSignedStateToDisk(@NonNull PlatformContext platformContext, @Nullable NodeId selfId, @NonNull Path savedStateDirectory, @Nullable StateToDiskReason stateToDiskReason, @NonNull SignedState signedState, @NonNull PlatformStateFacade platformStateFacade, @NonNull StateLifecycleManager stateLifecycleManager) throws IOException {
        Objects.requireNonNull(signedState);
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(savedStateDirectory);
        Objects.requireNonNull(stateLifecycleManager);
        try {
            logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Started writing round {} state to disk. Reason: {}, directory: {}", (Object)signedState.getRound(), stateToDiskReason == null ? "UNKNOWN" : stateToDiskReason, (Object)savedStateDirectory);
            FileUtils.executeAndRename((Path)savedStateDirectory, directory -> SignedStateFileWriter.writeSignedStateFilesToDirectory(platformContext, selfId, directory, signedState, platformStateFacade, stateLifecycleManager), (Configuration)platformContext.getConfiguration());
            logger.info(LogMarker.STATE_TO_DISK.getMarker(), () -> new StateSavedToDiskPayload(signedState.getRound(), signedState.isFreezeState(), stateToDiskReason == null ? "UNKNOWN" : stateToDiskReason.toString(), savedStateDirectory).toString());
        }
        catch (Throwable e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Exception when writing the signed state for round {} to disk:", (Object)signedState.getRound(), (Object)e);
            throw e;
        }
    }

    private static void writeEmergencyRecoveryFile(Path savedStateDirectory, SignedState signedState) throws IOException {
        new EmergencyRecoveryFile(signedState.getRound(), signedState.getState().getHash(), signedState.getConsensusTimestamp()).write(savedStateDirectory);
    }
}

