/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.contract.codec.EthereumTransactionBodyJsonCodec;
import com.hedera.hapi.node.contract.codec.EthereumTransactionBodyProtoCodec;
import com.hedera.hapi.node.contract.schema.EthereumTransactionBodySchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class EthereumTransactionBody {
    public static final Codec<EthereumTransactionBody> PROTOBUF = new EthereumTransactionBodyProtoCodec();
    public static final JsonCodec<EthereumTransactionBody> JSON = new EthereumTransactionBodyJsonCodec();
    public static final EthereumTransactionBody DEFAULT = EthereumTransactionBody.newBuilder().build();
    @NonNull
    private final Bytes ethereumData;
    @Nullable
    private final FileID callData;
    private final long maxGasAllowance;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public EthereumTransactionBody(Bytes ethereumData, FileID callData, long maxGasAllowance) {
        this.$unknownFields = null;
        this.ethereumData = ethereumData != null ? ethereumData : Bytes.EMPTY;
        this.callData = callData;
        this.maxGasAllowance = maxGasAllowance;
    }

    public EthereumTransactionBody(Bytes ethereumData, FileID callData, long maxGasAllowance, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.ethereumData = ethereumData != null ? ethereumData : Bytes.EMPTY;
        this.callData = callData;
        this.maxGasAllowance = maxGasAllowance;
    }

    public Bytes ethereumData() {
        return this.ethereumData;
    }

    public FileID callData() {
        return this.callData;
    }

    public long maxGasAllowance() {
        return this.maxGasAllowance;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)EthereumTransactionBodySchema.ETHEREUM_DATA, (RandomAccessData)this.ethereumData, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)EthereumTransactionBodySchema.CALL_DATA, (Object)this.callData, FileID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)EthereumTransactionBodySchema.MAX_GAS_ALLOWANCE, (long)this.maxGasAllowance, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.ethereumData != null && !this.ethereumData.equals((Object)EthereumTransactionBody.DEFAULT.ethereumData)) {
                result = 31 * result + this.ethereumData.hashCode();
            }
            if (this.callData != null && !this.callData.equals(EthereumTransactionBody.DEFAULT.callData)) {
                result = 31 * result + this.callData.hashCode();
            }
            if (this.maxGasAllowance != EthereumTransactionBody.DEFAULT.maxGasAllowance) {
                result = 31 * result + Long.hashCode(this.maxGasAllowance);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        EthereumTransactionBody thatObj = (EthereumTransactionBody)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.ethereumData == null && thatObj.ethereumData != null) {
            return false;
        }
        if (this.ethereumData != null && !this.ethereumData.equals((Object)thatObj.ethereumData)) {
            return false;
        }
        if (this.callData == null && thatObj.callData != null) {
            return false;
        }
        if (this.callData != null && !this.callData.equals(thatObj.callData)) {
            return false;
        }
        if (this.maxGasAllowance != thatObj.maxGasAllowance) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "EthereumTransactionBody[ethereumData=" + String.valueOf(this.ethereumData) + ", callData=" + String.valueOf(this.callData) + ", maxGasAllowance=" + this.maxGasAllowance + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasCallData() {
        return this.callData != null;
    }

    public FileID callDataOrElse(@NonNull FileID defaultValue) {
        return this.hasCallData() ? this.callData : defaultValue;
    }

    @NonNull
    public FileID callDataOrThrow() {
        return Objects.requireNonNull(this.callData, "Field callData is null");
    }

    public void ifCallData(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasCallData()) {
            ifPresent.accept(this.callData);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.ethereumData, this.callData, this.maxGasAllowance, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @NonNull
        private Bytes ethereumData = Bytes.EMPTY;
        @Nullable
        private FileID callData = null;
        private long maxGasAllowance = 0L;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(Bytes ethereumData, FileID callData, long maxGasAllowance) {
            this.$unknownFields = null;
            this.ethereumData = ethereumData != null ? ethereumData : Bytes.EMPTY;
            this.callData = callData;
            this.maxGasAllowance = maxGasAllowance;
        }

        public Builder(Bytes ethereumData, FileID callData, long maxGasAllowance, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.ethereumData = ethereumData != null ? ethereumData : Bytes.EMPTY;
            this.callData = callData;
            this.maxGasAllowance = maxGasAllowance;
        }

        public EthereumTransactionBody build() {
            return new EthereumTransactionBody(this.ethereumData, this.callData, this.maxGasAllowance);
        }

        public Builder ethereumData(@NonNull Bytes ethereumData) {
            this.ethereumData = ethereumData != null ? ethereumData : Bytes.EMPTY;
            return this;
        }

        public Builder callData(@Nullable FileID callData) {
            this.callData = callData;
            return this;
        }

        public Builder callData(FileID.Builder builder) {
            this.callData = builder.build();
            return this;
        }

        public Builder maxGasAllowance(long maxGasAllowance) {
            this.maxGasAllowance = maxGasAllowance;
            return this;
        }
    }
}

