/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model.internal.standard;

import com.swirlds.base.time.Time;
import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.model.diagram.HyperlinkBuilder;
import com.swirlds.component.framework.model.internal.standard.HeartbeatTask;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.wires.output.OutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractHeartbeatScheduler {
    public static final String HEARTBEAT_SCHEDULER_NAME = "Heartbeat";
    private final TraceableWiringModel model;
    protected final Time time;
    protected final List<HeartbeatTask> tasks = new ArrayList<HeartbeatTask>();
    protected boolean started;

    public AbstractHeartbeatScheduler(@NonNull TraceableWiringModel model, @NonNull Time time) {
        this.model = Objects.requireNonNull(model);
        this.time = Objects.requireNonNull(time);
        model.registerVertex(HEARTBEAT_SCHEDULER_NAME, TaskSchedulerType.SEQUENTIAL, HyperlinkBuilder.platformCommonHyperlink(AbstractHeartbeatScheduler.class), false);
    }

    @NonNull
    public OutputWire<Instant> buildHeartbeatWire(@NonNull Duration period, @NonNull Thread.UncaughtExceptionHandler exceptionHandler) {
        if (this.started) {
            throw new IllegalStateException("Cannot create heartbeat wires after the heartbeat has started");
        }
        if (period.isNegative() || period.isZero()) {
            throw new IllegalArgumentException("Period must be positive");
        }
        if (period.toMillis() == 0L) {
            throw new IllegalArgumentException("Time is measured at millisecond precision, and so periods less than 1ms are not supported. Requested period: " + String.valueOf(period));
        }
        HeartbeatTask task = new HeartbeatTask(this.model, HEARTBEAT_SCHEDULER_NAME, this.time, period, exceptionHandler);
        this.tasks.add(task);
        return task.getOutputWire();
    }

    public OutputWire<Instant> buildHeartbeatWire(double frequency, @NonNull Thread.UncaughtExceptionHandler exceptionHandler) {
        if (frequency <= 0.0) {
            throw new IllegalArgumentException("Frequency must be positive");
        }
        Duration period = Duration.ofMillis((long)(1000.0 / frequency));
        return this.buildHeartbeatWire(period, exceptionHandler);
    }

    public abstract void start();

    public abstract void stop();
}

