/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.hashlogger;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.state.hashlogger.HashLogger;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;

public class DefaultHashLogger
implements HashLogger {
    private static final Logger logger = LogManager.getLogger(DefaultHashLogger.class);
    private static final MessageFactory MESSAGE_FACTORY = ParameterizedMessageFactory.INSTANCE;
    private final AtomicLong lastRoundLogged = new AtomicLong(-1L);
    private final int depth;
    private final Logger logOutput;
    private final boolean isEnabled;
    private final PlatformStateFacade platformStateFacade;

    public DefaultHashLogger(@NonNull PlatformContext platformContext, @NonNull PlatformStateFacade platformStateFacade) {
        this(platformContext, logger, platformStateFacade);
    }

    DefaultHashLogger(@NonNull PlatformContext platformContext, @NonNull Logger logOutput, @NonNull PlatformStateFacade platformStateFacade) {
        StateConfig stateConfig = (StateConfig)platformContext.getConfiguration().getConfigData(StateConfig.class);
        this.depth = stateConfig.debugHashDepth();
        this.isEnabled = stateConfig.enableHashStreamLogging();
        this.logOutput = Objects.requireNonNull(logOutput);
        this.platformStateFacade = platformStateFacade;
    }

    @Override
    public void logHashes(@NonNull ReservedSignedState reservedState) {
        try (ReservedSignedState reservedSignedState = reservedState;){
            if (!this.isEnabled) {
                return;
            }
            SignedState signedState = reservedState.get();
            long currentRound = signedState.getRound();
            long prevRound = this.lastRoundLogged.getAndUpdate(value -> Math.max(value, currentRound));
            if (prevRound >= 0L && currentRound - prevRound > 1L) {
                this.logOutput.info(LogMarker.STATE_HASH.getMarker(), () -> MESSAGE_FACTORY.newMessage("*** Several rounds skipped. Round received {}. Previously received {}.", new Object[]{currentRound, prevRound}));
            }
            if (currentRound > prevRound) {
                this.logOutput.info(LogMarker.STATE_HASH.getMarker(), () -> this.generateLogMessage(signedState));
            }
        }
    }

    @NonNull
    private Message generateLogMessage(@NonNull SignedState signedState) {
        String platformInfo = this.platformStateFacade.getInfoString((State)signedState.getState(), this.depth);
        return MESSAGE_FACTORY.newMessage("State Info, round = {}:\n{}", new Object[]{signedState.getRound(), platformInfo});
    }
}

