/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gossip.shadowgraph;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.threading.framework.Stoppable;
import com.swirlds.common.threading.pool.ParallelExecutionException;
import com.swirlds.common.threading.pool.ParallelExecutor;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.gossip.IntakeEventCounter;
import com.swirlds.platform.gossip.SyncException;
import com.swirlds.platform.gossip.shadowgraph.AbstractShadowgraphSynchronizer;
import com.swirlds.platform.gossip.shadowgraph.ReservedEventWindow;
import com.swirlds.platform.gossip.shadowgraph.ShadowEvent;
import com.swirlds.platform.gossip.shadowgraph.Shadowgraph;
import com.swirlds.platform.gossip.shadowgraph.SyncResult;
import com.swirlds.platform.gossip.shadowgraph.SyncTiming;
import com.swirlds.platform.gossip.shadowgraph.SyncUtils;
import com.swirlds.platform.gossip.shadowgraph.TheirTipsAndEventWindow;
import com.swirlds.platform.gossip.sync.config.SyncConfig;
import com.swirlds.platform.metrics.SyncMetrics;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.reconnect.FallenBehindMonitor;
import com.swirlds.platform.reconnect.FallenBehindStatus;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.concurrent.ThrowingRunnable;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.gossip.SyncProgress;
import org.hiero.consensus.model.hashgraph.EventWindow;

public class ShadowgraphSynchronizer
extends AbstractShadowgraphSynchronizer {
    private static final Logger logger = LogManager.getLogger();
    private final ParallelExecutor executor;

    public ShadowgraphSynchronizer(@NonNull PlatformContext platformContext, @NonNull Shadowgraph shadowGraph, int numberOfNodes, @NonNull SyncMetrics syncMetrics, @NonNull Consumer<PlatformEvent> receivedEventHandler, @NonNull FallenBehindMonitor fallenBehindManager, @NonNull IntakeEventCounter intakeEventCounter, @NonNull ParallelExecutor executor, @NonNull Consumer<SyncProgress> syncProgressHandler) {
        super(platformContext, shadowGraph, numberOfNodes, syncMetrics, receivedEventHandler, fallenBehindManager, intakeEventCounter, syncProgressHandler);
        this.executor = Objects.requireNonNull(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean synchronize(@NonNull PlatformContext platformContext, @NonNull Connection connection, boolean ignoreIncomingEvents) throws IOException, ParallelExecutionException, SyncException, InterruptedException {
        logger.info(LogMarker.SYNC_INFO.getMarker(), "{} sync start", (Object)connection.getDescription());
        try {
            boolean bl = this.reserveSynchronize(platformContext, connection, ignoreIncomingEvents);
            return bl;
        }
        finally {
            logger.info(LogMarker.SYNC_INFO.getMarker(), "{} sync end", (Object)connection.getDescription());
        }
    }

    private boolean reserveSynchronize(@NonNull PlatformContext platformContext, @NonNull Connection connection, boolean ignoreIncomingEvents) throws IOException, ParallelExecutionException, SyncException {
        List<Object> sendList;
        SyncTiming timing = new SyncTiming();
        try (ReservedEventWindow reservation = this.reserveEventWindow();){
            connection.initForSync();
            timing.start();
            EventWindow myWindow = reservation.getEventWindow();
            List<ShadowEvent> myTips = this.getTips();
            TheirTipsAndEventWindow theirTipsAndEventWindow = this.readWriteParallel(SyncUtils.readTheirTipsAndEventWindow(connection, this.numberOfNodes), SyncUtils.writeMyTipsAndEventWindow(connection, myWindow, myTips), connection);
            timing.setTimePoint(1);
            this.syncMetrics.eventWindow(myWindow, theirTipsAndEventWindow.eventWindow());
            this.reportSyncStatus(myWindow, theirTipsAndEventWindow.eventWindow(), connection.getOtherId());
            FallenBehindStatus status = this.fallenBehindMonitor.check(myWindow, theirTipsAndEventWindow.eventWindow(), connection.getOtherId());
            if (status != FallenBehindStatus.NONE_FALLEN_BEHIND) {
                logger.info(LogMarker.SYNC_INFO.getMarker(), "Connection against {} aborting sync due to {}", (Object)connection.getOtherId(), (Object)status);
                boolean bl = false;
                return bl;
            }
            HashSet<ShadowEvent> eventsTheyHave = new HashSet<ShadowEvent>();
            List<ShadowEvent> theirTips = this.shadows(theirTipsAndEventWindow.tips());
            List<Boolean> theirTipsIHave = SyncUtils.getTheirTipsIHave(theirTips);
            theirTips.stream().filter(Objects::nonNull).forEach(eventsTheyHave::add);
            timing.setTimePoint(2);
            SyncUtils.TipsInfo tipsInfo = this.readWriteParallel(SyncUtils.readMyTipsTheyHave(connection, myTips.size()), SyncUtils.writeTheirTipsIHave(connection, theirTipsIHave, ignoreIncomingEvents), connection);
            timing.setTimePoint(3);
            List<ShadowEvent> knownTips = SyncUtils.getMyTipsTheyKnow(connection, myTips, tipsInfo.theirTips());
            eventsTheyHave.addAll(knownTips);
            sendList = tipsInfo.dontSentEvents() ? Collections.emptyList() : this.createSendList(connection.getSelfId(), eventsTheyHave, myWindow, theirTipsAndEventWindow.eventWindow());
        }
        SyncConfig syncConfig = (SyncConfig)platformContext.getConfiguration().getConfigData(SyncConfig.class);
        return this.sendAndReceiveEvents(connection, timing, sendList, syncConfig.syncKeepalivePeriod(), syncConfig.maxSyncTime(), ignoreIncomingEvents);
    }

    private boolean sendAndReceiveEvents(@NonNull Connection connection, @NonNull SyncTiming timing, @NonNull List<PlatformEvent> sendList, @NonNull Duration syncKeepAlivePeriod, @NonNull Duration maxSyncTime, boolean ignoreIncomingEvents) throws ParallelExecutionException {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(sendList);
        timing.setTimePoint(4);
        CountDownLatch eventReadingDone = new CountDownLatch(1);
        AtomicBoolean writeAborted = new AtomicBoolean(false);
        Integer eventsRead = this.readWriteParallel(SyncUtils.readEventsINeed(connection, this.eventHandler, this.maximumEventsPerSync, this.syncMetrics, eventReadingDone, this.intakeEventCounter, maxSyncTime, ignoreIncomingEvents), SyncUtils.sendEventsTheyNeed(connection, sendList, eventReadingDone, writeAborted, syncKeepAlivePeriod), connection);
        if (eventsRead < 0 || writeAborted.get()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = connection::getDescription;
            logger.info(LogMarker.SYNC_INFO.getMarker(), "{} sync aborted", supplierArray);
            return false;
        }
        logger.info(LogMarker.SYNC_INFO.getMarker(), "{} writing events done, wrote {} events", (Object)connection.getDescription(), (Object)sendList.size());
        logger.info(LogMarker.SYNC_INFO.getMarker(), "{} reading events done, read {} events", (Object)connection.getDescription(), (Object)eventsRead);
        this.syncMetrics.syncDone(new SyncResult(connection.getOtherId(), eventsRead, sendList.size()), connection.isOutbound());
        timing.setTimePoint(5);
        this.syncMetrics.recordSyncTiming(timing, connection);
        return true;
    }

    @Nullable
    private <T> T readWriteParallel(@NonNull Callable<T> readTask, @NonNull ThrowingRunnable writeTask, @NonNull Connection connection) throws ParallelExecutionException {
        Objects.requireNonNull(readTask);
        Objects.requireNonNull(writeTask);
        Objects.requireNonNull(connection);
        return (T)this.executor.doParallelWithHandler(connection::disconnect, readTask, new ThrowingRunnable[]{writeTask});
    }

    @Override
    public void start() {
        this.executor.start();
    }

    @Override
    public void stop() {
        ParallelExecutor parallelExecutor = this.executor;
        if (parallelExecutor instanceof Stoppable) {
            Stoppable stoppable = (Stoppable)parallelExecutor;
            stoppable.stop(Stoppable.StopBehavior.INTERRUPTABLE);
        }
    }
}

