/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.editor;

import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.crypto.MerkleCryptographyFactory;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.platform.config.DefaultConfiguration;
import com.swirlds.platform.state.editor.StateEditorOperation;
import com.swirlds.platform.state.editor.StateEditorRoot;
import com.swirlds.platform.state.signed.ReservedSignedState;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import picocli.CommandLine;

@CommandLine.Command(name="hash", mixinStandardHelpOptions=true, description={"Hash unhashed nodes the state."})
@SubcommandOf(value=StateEditorRoot.class)
public class StateEditorHash
extends StateEditorOperation {
    @Override
    public void run() {
        try (ReservedSignedState reservedSignedState = this.getStateEditor().getState("StateEditorHash.run()");){
            Configuration configuration = DefaultConfiguration.buildBasicConfiguration(ConfigurationBuilder.create());
            MerkleCryptography merkleCryptography = MerkleCryptographyFactory.create((Configuration)configuration);
            merkleCryptography.digestTreeAsync(reservedSignedState.get().getState().getRoot()).get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

