/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.connectivity;

import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.network.connectivity.SocketFactory;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.interrupt.InterruptableRunnable;

public class ConnectionServer
implements InterruptableRunnable {
    private static final int SLEEP_AFTER_BIND_FAILED_MS = 100;
    private static final Logger logger = LogManager.getLogger(ConnectionServer.class);
    private final int port;
    private final SocketFactory socketFactory;
    private final Consumer<Socket> newConnectionHandler;
    private final ExecutorService incomingConnPool;

    public ConnectionServer(ThreadManager threadManager, int port, SocketFactory socketFactory, Consumer<Socket> newConnectionHandler) {
        this.port = port;
        this.newConnectionHandler = newConnectionHandler;
        this.socketFactory = socketFactory;
        this.incomingConnPool = Executors.newCachedThreadPool(((ThreadConfiguration)new ThreadConfiguration(threadManager).setThreadName("sync_server")).buildFactory());
    }

    public void run() throws InterruptedException {
        try (ServerSocket serverSocket = this.socketFactory.createServerSocket(this.port);){
            this.listen(serverSocket);
        }
        catch (IOException | RuntimeException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Cannot bind ServerSocket on port {}", (Object)this.port, (Object)e);
        }
        Thread.sleep(100L);
    }

    private void listen(ServerSocket serverSocket) throws InterruptedException {
        while (!serverSocket.isClosed()) {
            try {
                Socket clientSocket = serverSocket.accept();
                this.incomingConnPool.submit(() -> this.newConnectionHandler.accept(clientSocket));
            }
            catch (SocketTimeoutException expectedWithNonZeroSOTimeout) {
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException();
            }
            catch (IOException | RuntimeException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "SyncServer serverSocket.accept() error", (Throwable)e);
            }
        }
    }
}

