/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream;

import com.hedera.hapi.block.stream.SiblingNode;
import com.hedera.hapi.block.stream.codec.MerklePathJsonCodec;
import com.hedera.hapi.block.stream.codec.MerklePathProtoCodec;
import com.hedera.hapi.block.stream.schema.MerklePathSchema;
import com.hedera.hapi.node.state.blockstream.MerkleLeaf;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class MerklePath {
    public static final Codec<MerklePath> PROTOBUF = new MerklePathProtoCodec();
    public static final JsonCodec<MerklePath> JSON = new MerklePathJsonCodec();
    public static final MerklePath DEFAULT = MerklePath.newBuilder().build();
    private final OneOf<ContentOneOfType> content;
    @NonNull
    private final List<SiblingNode> siblings;
    private final int nextPathIndex;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public MerklePath(OneOf<ContentOneOfType> content, List<SiblingNode> siblings, int nextPathIndex) {
        this.$unknownFields = null;
        if (content == null) {
            throw new NullPointerException("Parameter 'content' must be supplied and can not be null");
        }
        this.content = content;
        this.siblings = siblings == null ? Collections.emptyList() : siblings;
        this.nextPathIndex = nextPathIndex;
    }

    public MerklePath(OneOf<ContentOneOfType> content, List<SiblingNode> siblings, int nextPathIndex, List<UnknownField> $unknownFields) {
        List<UnknownField> list = this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        if (content == null) {
            throw new NullPointerException("Parameter 'content' must be supplied and can not be null");
        }
        this.content = content;
        this.siblings = siblings == null ? Collections.emptyList() : siblings;
        this.nextPathIndex = nextPathIndex;
    }

    public OneOf<ContentOneOfType> content() {
        return this.content;
    }

    public List<SiblingNode> siblings() {
        return this.siblings;
    }

    public int nextPathIndex() {
        return this.nextPathIndex;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            if (this.content.kind() == ContentOneOfType.LEAF) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)MerklePathSchema.LEAF, (Object)((MerkleLeaf)this.content.as()), MerkleLeaf.PROTOBUF);
            }
            if (this.content.kind() == ContentOneOfType.HASH) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)MerklePathSchema.HASH, (RandomAccessData)((RandomAccessData)this.content.as()), (boolean)true);
            }
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)MerklePathSchema.SIBLINGS, this.siblings, SiblingNode.PROTOBUF);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)MerklePathSchema.NEXT_PATH_INDEX, (int)this.nextPathIndex, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            List<SiblingNode> list$siblings;
            int result = 1;
            if (this.content != null && !this.content.equals(MerklePath.DEFAULT.content)) {
                result = 31 * result + this.content.hashCode();
            }
            if ((list$siblings = this.siblings) != null) {
                for (SiblingNode o : list$siblings) {
                    if (o != null) {
                        result = 31 * result + ((Object)o).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.nextPathIndex != MerklePath.DEFAULT.nextPathIndex) {
                result = 31 * result + Integer.hashCode(this.nextPathIndex);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        MerklePath thatObj = (MerklePath)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.content == null && thatObj.content != null) {
            return false;
        }
        if (this.content != null && !this.content.equals(thatObj.content)) {
            return false;
        }
        if (this.siblings == null && thatObj.siblings != null) {
            return false;
        }
        if (this.siblings != null && !this.siblings.equals(thatObj.siblings)) {
            return false;
        }
        if (this.nextPathIndex != thatObj.nextPathIndex) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "MerklePath[content=" + String.valueOf(this.content) + ", siblings=" + String.valueOf(this.siblings) + ", nextPathIndex=" + this.nextPathIndex + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public MerkleLeaf leaf() {
        return this.content.kind() == ContentOneOfType.LEAF ? (MerkleLeaf)this.content.value() : null;
    }

    public boolean hasLeaf() {
        return this.content.kind() == ContentOneOfType.LEAF;
    }

    public MerkleLeaf leafOrElse(@NonNull MerkleLeaf defaultValue) {
        return this.hasLeaf() ? this.leaf() : defaultValue;
    }

    @NonNull
    public MerkleLeaf leafOrThrow() {
        return Objects.requireNonNull(this.leaf(), "Field leaf is null");
    }

    @Nullable
    public Bytes hash() {
        return this.content.kind() == ContentOneOfType.HASH ? (Bytes)this.content.value() : null;
    }

    public boolean hasHash() {
        return this.content.kind() == ContentOneOfType.HASH;
    }

    public Bytes hashOrElse(@NonNull Bytes defaultValue) {
        return this.hasHash() ? this.hash() : defaultValue;
    }

    @NonNull
    public Bytes hashOrThrow() {
        return Objects.requireNonNull(this.hash(), "Field hash is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.content, this.siblings, this.nextPathIndex, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum ContentOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        LEAF(1, "leaf"),
        HASH(2, "hash");

        private final int protoOrdinal;
        private final String protoName;

        private ContentOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static ContentOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 1 -> LEAF;
                case 2 -> HASH;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static ContentOneOfType fromString(String name) {
            return switch (name) {
                case "leaf", "LEAF" -> LEAF;
                case "hash", "HASH" -> HASH;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private OneOf<ContentOneOfType> content = MerklePathProtoCodec.CONTENT_UNSET;
        @NonNull
        private List<SiblingNode> siblings = Collections.emptyList();
        private int nextPathIndex = 0;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(OneOf<ContentOneOfType> content, List<SiblingNode> siblings, int nextPathIndex) {
            this.$unknownFields = null;
            this.content = content;
            this.siblings = siblings == null ? Collections.emptyList() : siblings;
            this.nextPathIndex = nextPathIndex;
        }

        public Builder(OneOf<ContentOneOfType> content, List<SiblingNode> siblings, int nextPathIndex, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.content = content;
            this.siblings = siblings == null ? Collections.emptyList() : siblings;
            this.nextPathIndex = nextPathIndex;
        }

        public MerklePath build() {
            return new MerklePath(this.content, this.siblings, this.nextPathIndex);
        }

        public Builder leaf(@Nullable MerkleLeaf leaf) {
            this.content = new OneOf((Enum)ContentOneOfType.LEAF, (Object)leaf);
            return this;
        }

        public Builder leaf(MerkleLeaf.Builder builder) {
            this.content = new OneOf((Enum)ContentOneOfType.LEAF, (Object)builder.build());
            return this;
        }

        public Builder hash(@NonNull Bytes hash) {
            this.content = new OneOf((Enum)ContentOneOfType.HASH, (Object)hash);
            return this;
        }

        public Builder siblings(@NonNull List<SiblingNode> siblings) {
            this.siblings = siblings != null ? siblings : Collections.emptyList();
            return this;
        }

        public Builder siblings(SiblingNode ... values) {
            this.siblings = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder nextPathIndex(int nextPathIndex) {
            this.nextPathIndex = nextPathIndex;
            return this;
        }
    }
}

