/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.factory.Bags;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.MutableIntValuesMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedIntCollection;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntBags;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractSentinelValues;
import org.eclipse.collections.impl.primitive.AbstractIntIterable;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;

public abstract class AbstractMutableIntValuesMap
extends AbstractIntIterable
implements MutableIntValuesMap {
    protected abstract int getOccupiedWithData();

    protected abstract SentinelValues getSentinelValues();

    protected abstract void setSentinelValuesNull();

    protected abstract int getEmptyValue();

    protected abstract int getValueAtIndex(int var1);

    protected abstract int getTableSize();

    protected abstract boolean isNonSentinelAtIndex(int var1);

    protected void addEmptyKeyValue(int value) {
        this.getSentinelValues().containsZeroKey = true;
        this.getSentinelValues().zeroValue = value;
    }

    protected void removeEmptyKey() {
        if (this.getSentinelValues().containsOneKey) {
            this.getSentinelValues().containsZeroKey = false;
            this.getSentinelValues().zeroValue = this.getEmptyValue();
        } else {
            this.setSentinelValuesNull();
        }
    }

    protected void addRemovedKeyValue(int value) {
        this.getSentinelValues().containsOneKey = true;
        this.getSentinelValues().oneValue = value;
    }

    protected void removeRemovedKey() {
        if (this.getSentinelValues().containsZeroKey) {
            this.getSentinelValues().containsOneKey = false;
            this.getSentinelValues().oneValue = this.getEmptyValue();
        } else {
            this.setSentinelValuesNull();
        }
    }

    public boolean contains(int value) {
        return this.containsValue(value);
    }

    public boolean containsAll(IntIterable source) {
        return source.allSatisfy((IntPredicate & Serializable)value -> this.contains(value));
    }

    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        MutableIntIterator iterator = this.intIterator();
        int max = iterator.next();
        while (iterator.hasNext()) {
            int value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        MutableIntIterator iterator = this.intIterator();
        int min = iterator.next();
        while (iterator.hasNext()) {
            int value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public int size() {
        return this.getOccupiedWithData() + (this.getSentinelValues() == null ? 0 : this.getSentinelValues().size());
    }

    public boolean isEmpty() {
        return this.getOccupiedWithData() == 0 && (this.getSentinelValues() == null || this.getSentinelValues().size() == 0);
    }

    public boolean notEmpty() {
        return this.getOccupiedWithData() != 0 || this.getSentinelValues() != null && this.getSentinelValues().size() != 0;
    }

    public void each(IntProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.getSentinelValues() != null) {
                if (this.getSentinelValues().containsZeroKey) {
                    appendable.append(String.valueOf(this.getSentinelValues().zeroValue));
                    first = false;
                }
                if (this.getSentinelValues().containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.getSentinelValues().oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.getTableSize(); ++i) {
                if (!this.isNonSentinelAtIndex(i)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.getValueAtIndex(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int[] toArray() {
        int[] array = new int[this.size()];
        int index = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                array[index] = this.getSentinelValues().zeroValue;
                ++index;
            }
            if (this.getSentinelValues().containsOneKey) {
                array[index] = this.getSentinelValues().oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            array[index] = this.getValueAtIndex(i);
            ++index;
        }
        return array;
    }

    public int[] toArray(int[] target) {
        if (target.length < this.size()) {
            target = new int[this.size()];
        }
        int index = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                target[index] = this.getSentinelValues().zeroValue;
                ++index;
            }
            if (this.getSentinelValues().containsOneKey) {
                target[index] = this.getSentinelValues().oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            target[index] = this.getValueAtIndex(i);
            ++index;
        }
        return target;
    }

    public MutableIntBag select(IntPredicate predicate) {
        return (MutableIntBag)this.select(predicate, (MutableIntCollection)new IntHashBag());
    }

    public MutableIntBag reject(IntPredicate predicate) {
        return (MutableIntBag)this.reject(predicate, (MutableIntCollection)new IntHashBag());
    }

    public <V> MutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        return (MutableBag)this.collect(function, (Collection)Bags.mutable.withInitialCapacity(this.size()));
    }

    public int detectIfNone(IntPredicate predicate, int value) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue)) {
                return this.getSentinelValues().zeroValue;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue)) {
                return this.getSentinelValues().oneValue;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || !predicate.accept(this.getValueAtIndex(i))) continue;
            return this.getValueAtIndex(i);
        }
        return value;
    }

    public int count(IntPredicate predicate) {
        int count = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue)) {
                ++count;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || !predicate.accept(this.getValueAtIndex(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue)) {
                return true;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || !predicate.accept(this.getValueAtIndex(i))) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(this.getSentinelValues().zeroValue)) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(this.getSentinelValues().oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || predicate.accept(this.getValueAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    public RichIterable<IntIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)IntBags.mutable.withAll((IntIterable)this));
            } else {
                MutableIntIterator iterator = this.intIterator();
                while (iterator.hasNext()) {
                    MutableIntBag batch = IntBags.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch);
                }
            }
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += (long)this.getSentinelValues().zeroValue;
            }
            if (this.getSentinelValues().containsOneKey) {
                result += (long)this.getSentinelValues().oneValue;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            result += (long)this.getValueAtIndex(i);
        }
        return result;
    }

    public boolean containsValue(int value) {
        if (this.getSentinelValues() != null && this.getSentinelValues().containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || this.getValueAtIndex(i) != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(IntProcedure procedure) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                procedure.value(this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey) {
                procedure.value(this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            procedure.value(this.getValueAtIndex(i));
        }
    }

    protected static class SentinelValues
    extends AbstractSentinelValues {
        protected int zeroValue;
        protected int oneValue;

        protected SentinelValues() {
        }

        public boolean containsValue(int value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }

        public SentinelValues copy() {
            SentinelValues sentinelValues = new SentinelValues();
            sentinelValues.zeroValue = this.zeroValue;
            sentinelValues.oneValue = this.oneValue;
            sentinelValues.containsOneKey = this.containsOneKey;
            sentinelValues.containsZeroKey = this.containsZeroKey;
            return sentinelValues;
        }
    }

    protected abstract class AbstractIntValuesCollection
    implements MutableIntCollection {
        protected AbstractIntValuesCollection() {
        }

        public void clear() {
            AbstractMutableIntValuesMap.this.clear();
        }

        public MutableIntCollection select(IntPredicate predicate) {
            return AbstractMutableIntValuesMap.this.select(predicate);
        }

        public MutableIntCollection reject(IntPredicate predicate) {
            return AbstractMutableIntValuesMap.this.reject(predicate);
        }

        public int detectIfNone(IntPredicate predicate, int ifNone) {
            return AbstractMutableIntValuesMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
            return AbstractMutableIntValuesMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            return (T)AbstractMutableIntValuesMap.this.injectInto(injectedValue, function);
        }

        public RichIterable<IntIterable> chunk(int size) {
            return AbstractMutableIntValuesMap.this.chunk(size);
        }

        public long sum() {
            return AbstractMutableIntValuesMap.this.sum();
        }

        public int max() {
            return AbstractMutableIntValuesMap.this.max();
        }

        public int maxIfEmpty(int defaultValue) {
            return AbstractMutableIntValuesMap.this.maxIfEmpty(defaultValue);
        }

        public int min() {
            return AbstractMutableIntValuesMap.this.min();
        }

        public int minIfEmpty(int defaultValue) {
            return AbstractMutableIntValuesMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return AbstractMutableIntValuesMap.this.average();
        }

        public double median() {
            return AbstractMutableIntValuesMap.this.median();
        }

        public int[] toSortedArray() {
            return AbstractMutableIntValuesMap.this.toSortedArray();
        }

        public MutableIntList toSortedList() {
            return AbstractMutableIntValuesMap.this.toSortedList();
        }

        public MutableIntCollection with(int element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection without(int element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection withAll(IntIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection withoutAll(IntIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableIntCollection asUnmodifiable() {
            return UnmodifiableIntCollection.of(this);
        }

        public MutableIntCollection asSynchronized() {
            return SynchronizedIntCollection.of(this);
        }

        public ImmutableIntCollection toImmutable() {
            return IntLists.immutable.withAll((IntIterable)this);
        }

        public boolean contains(int value) {
            return AbstractMutableIntValuesMap.this.containsValue(value);
        }

        public boolean containsAll(int ... source) {
            return AbstractMutableIntValuesMap.this.containsAll(source);
        }

        public boolean containsAll(IntIterable source) {
            return AbstractMutableIntValuesMap.this.containsAll(source);
        }

        public MutableIntList toList() {
            return AbstractMutableIntValuesMap.this.toList();
        }

        public MutableIntSet toSet() {
            return AbstractMutableIntValuesMap.this.toSet();
        }

        public MutableIntBag toBag() {
            return AbstractMutableIntValuesMap.this.toBag();
        }

        public LazyIntIterable asLazy() {
            return new LazyIntIterableAdapter((IntIterable)this);
        }

        public boolean isEmpty() {
            return AbstractMutableIntValuesMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return AbstractMutableIntValuesMap.this.notEmpty();
        }

        public String makeString() {
            return AbstractMutableIntValuesMap.this.makeString();
        }

        public String makeString(String separator) {
            return AbstractMutableIntValuesMap.this.makeString(separator);
        }

        public String makeString(String start, String separator, String end) {
            return AbstractMutableIntValuesMap.this.makeString(start, separator, end);
        }

        public void appendString(Appendable appendable) {
            AbstractMutableIntValuesMap.this.appendString(appendable);
        }

        public void appendString(Appendable appendable, String separator) {
            AbstractMutableIntValuesMap.this.appendString(appendable, separator);
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            AbstractMutableIntValuesMap.this.appendString(appendable, start, separator, end);
        }

        public void each(IntProcedure procedure) {
            AbstractMutableIntValuesMap.this.each(procedure);
        }

        public int count(IntPredicate predicate) {
            return AbstractMutableIntValuesMap.this.count(predicate);
        }

        public boolean anySatisfy(IntPredicate predicate) {
            return AbstractMutableIntValuesMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(IntPredicate predicate) {
            return AbstractMutableIntValuesMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(IntPredicate predicate) {
            return AbstractMutableIntValuesMap.this.noneSatisfy(predicate);
        }

        public boolean add(int element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(int ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(IntIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean removeAll(IntIterable source) {
            int oldSize = AbstractMutableIntValuesMap.this.size();
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != AbstractMutableIntValuesMap.this.size();
        }

        public boolean removeAll(int ... source) {
            int oldSize = AbstractMutableIntValuesMap.this.size();
            for (int item : source) {
                this.remove(item);
            }
            return oldSize != AbstractMutableIntValuesMap.this.size();
        }

        public boolean retainAll(int ... source) {
            return this.retainAll(IntHashSet.newSetWith(source));
        }

        public int size() {
            return AbstractMutableIntValuesMap.this.size();
        }

        public int[] toArray() {
            return AbstractMutableIntValuesMap.this.toArray();
        }

        public int[] toArray(int[] target) {
            return AbstractMutableIntValuesMap.this.toArray(target);
        }
    }
}

