/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.wiring;

import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.io.IOIterator;
import com.swirlds.common.stream.RunningEventHashOverride;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.platform.components.AppNotifier;
import com.swirlds.platform.components.EventWindowManager;
import com.swirlds.platform.components.consensus.ConsensusEngine;
import com.swirlds.platform.event.branching.BranchDetector;
import com.swirlds.platform.event.branching.BranchReporter;
import com.swirlds.platform.event.deduplication.EventDeduplicator;
import com.swirlds.platform.event.orphan.OrphanBuffer;
import com.swirlds.platform.event.preconsensus.InlinePcesWriter;
import com.swirlds.platform.event.validation.EventSignatureValidator;
import com.swirlds.platform.listeners.ReconnectCompleteNotification;
import com.swirlds.platform.publisher.PlatformPublisher;
import com.swirlds.platform.state.hashlogger.HashLogger;
import com.swirlds.platform.state.iss.IssDetector;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.signed.StateSignatureCollector;
import com.swirlds.platform.state.snapshot.StateDumpRequest;
import com.swirlds.platform.state.snapshot.StateSnapshotManager;
import com.swirlds.platform.system.status.StatusActionSubmitter;
import com.swirlds.platform.system.status.StatusStateMachine;
import com.swirlds.platform.system.status.actions.PlatformStatusAction;
import com.swirlds.platform.wiring.NoInput;
import com.swirlds.platform.wiring.PlatformComponents;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.event.creator.impl.EventCreationManager;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.roster.RosterHistory;

public record PlatformCoordinator(@NonNull PlatformComponents components) implements StatusActionSubmitter
{
    public PlatformCoordinator {
        Objects.requireNonNull(components);
    }

    public void flushIntakePipeline() {
        this.components.eventHasherWiring().flush();
        this.components.internalEventValidatorWiring().flush();
        this.components.eventDeduplicatorWiring().flush();
        this.components.eventSignatureValidatorWiring().flush();
        this.components.orphanBufferWiring().flush();
        this.components.pcesInlineWriterWiring().flush();
        this.components.gossipWiring().flush();
        this.components.consensusEngineWiring().flush();
        this.components.applicationTransactionPrehandlerWiring().flush();
        this.components.eventCreationManagerWiring().flush();
        this.components.branchDetectorWiring().flush();
    }

    public void clear() {
        this.components.statusStateMachineWiring().flush();
        this.components.consensusEngineWiring().startSquelching();
        this.components.consensusEngineWiring().flush();
        this.components.eventCreationManagerWiring().startSquelching();
        this.components.eventCreationManagerWiring().flush();
        this.components.transactionHandlerWiring().startSquelching();
        this.components.transactionHandlerWiring().flush();
        this.flushIntakePipeline();
        this.components.stateHasherWiring().flush();
        this.components.stateSignatureCollectorWiring().flush();
        this.components.transactionHandlerWiring().flush();
        this.components.branchDetectorWiring().flush();
        this.components.branchReporterWiring().flush();
        this.components.consensusEngineWiring().stopSquelching();
        this.components.eventCreationManagerWiring().stopSquelching();
        this.components.transactionHandlerWiring().stopSquelching();
        this.components.eventDeduplicatorWiring().getInputWire(EventDeduplicator::clear).inject((Object)NoInput.getInstance());
        this.components.orphanBufferWiring().getInputWire(OrphanBuffer::clear).inject((Object)NoInput.getInstance());
        this.components.gossipWiring().getClearInput().inject((Object)NoInput.getInstance());
        this.components.stateSignatureCollectorWiring().getInputWire(StateSignatureCollector::clear).inject((Object)NoInput.getInstance());
        this.components.eventCreationManagerWiring().getInputWire(EventCreationManager::clear).inject((Object)NoInput.getInstance());
        this.components.branchDetectorWiring().getInputWire(BranchDetector::clear).inject((Object)NoInput.getInstance());
        this.components.branchReporterWiring().getInputWire(BranchReporter::clear).inject((Object)NoInput.getInstance());
    }

    public void startGossip() {
        this.components.gossipWiring().getStartInput().inject((Object)NoInput.getInstance());
    }

    public void sendStateToHashLogger(@NonNull SignedState signedState) {
        if (signedState.getState().getHash() != null) {
            ReservedSignedState stateReservedForHasher = signedState.reserve("logging state hash");
            boolean offerResult = this.components.hashLoggerWiring().getInputWire(HashLogger::logHashes).offer((Object)stateReservedForHasher);
            if (!offerResult) {
                stateReservedForHasher.close();
            }
        }
    }

    public void updateRunningHash(@NonNull RunningEventHashOverride runningHashUpdate) {
        this.components.runningEventHashOverrideWiring().runningHashUpdateInput().inject((Object)runningHashUpdate);
    }

    public void overrideIssDetectorState(@NonNull ReservedSignedState state) {
        this.components.issDetectorWiring().getInputWire(IssDetector::overridingState).put((Object)state);
    }

    public void signalEndOfPcesReplay() {
        this.components.issDetectorWiring().getInputWire(IssDetector::signalEndOfPreconsensusReplay).put((Object)NoInput.getInstance());
    }

    @NonNull
    public StatusActionSubmitter getStatusActionSubmitter() {
        return action -> this.components.statusStateMachineWiring().getInputWire(StatusStateMachine::submitStatusAction).put((Object)action);
    }

    public void updateEventWindow(@NonNull EventWindow eventWindow) {
        this.components.eventWindowManagerWiring().getInputWire(EventWindowManager::updateEventWindow).inject((Object)eventWindow);
        this.components.gossipWiring().flush();
    }

    public void consensusSnapshotOverride(@NonNull ConsensusSnapshot consensusSnapshot) {
        this.components.consensusEngineWiring().getInputWire(ConsensusEngine::outOfBandSnapshotUpdate).inject((Object)consensusSnapshot);
        if (this.components.platformPublisherWiring().getSchedulerType() != TaskSchedulerType.NO_OP) {
            this.components.platformPublisherWiring().getInputWire(PlatformPublisher::publishSnapshotOverride).inject((Object)consensusSnapshot);
        }
    }

    public void flushTransactionHandler() {
        this.components.transactionHandlerWiring().flush();
    }

    public void flushStateHasher() {
        this.components.stateHasherWiring().flush();
    }

    public void start() {
        this.components.model().start();
    }

    public void stop() {
        this.components.model().stop();
    }

    @Override
    public void submitStatusAction(@NonNull PlatformStatusAction action) {
        this.components.statusStateMachineWiring().getInputWire(StatusStateMachine::submitStatusAction).put((Object)action);
    }

    public void putSignatureCollectorState(@NonNull ReservedSignedState reserve) {
        this.components.stateSignatureCollectorWiring().getInputWire(StateSignatureCollector::addReservedState).put((Object)reserve);
    }

    public void injectRosterHistory(@NonNull RosterHistory rosterHistory) {
        this.components.eventSignatureValidatorWiring().getInputWire(EventSignatureValidator::updateRosterHistory).inject((Object)rosterHistory);
    }

    public void registerPcesDiscontinuity(long round) {
        this.components.pcesInlineWriterWiring().getInputWire(InlinePcesWriter::registerDiscontinuity).inject((Object)round);
    }

    public void sendReconnectCompleteNotification(@NonNull SignedState signedState) {
        this.components.notifierWiring().getInputWire(AppNotifier::sendReconnectCompleteNotification).put((Object)new ReconnectCompleteNotification(signedState.getRound(), signedState.getConsensusTimestamp(), signedState.getState()));
    }

    public void injectPcesMinimumGenerationToStore(@NonNull long minimumGenerationNonAncientForOldestState) {
        this.components.pcesInlineWriterWiring().getInputWire(InlinePcesWriter::setMinimumAncientIdentifierToStore).inject((Object)minimumGenerationNonAncientForOldestState);
    }

    public void injectPcesReplayerIterator(@NonNull IOIterator<PlatformEvent> iterator) {
        this.components.pcesReplayerWiring().pcesIteratorInputWire().inject(iterator);
    }

    public void dumpStateToDisk(@NonNull StateDumpRequest request) {
        this.components.stateSnapshotManagerWiring().getInputWire(StateSnapshotManager::dumpStateTask).put((Object)request);
    }

    public void injectSignatureCollectorState(@NonNull ReservedSignedState reservedSignedState) {
        this.components.stateSignatureCollectorWiring().getInputWire(StateSignatureCollector::addReservedState).put((Object)reservedSignedState);
    }
}

