/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.merkledb.MerkleDbDataSource;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import java.util.ArrayList;
import org.hiero.base.crypto.Hash;

public class DataSourceValidator {
    private static final String WHITESPACE = " ".repeat(20);
    private final MerkleDbDataSource dataSource;
    private int progressPercentage = 0;

    public DataSourceValidator(MerkleDbDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean validate() {
        try {
            long path;
            long firstLeafPath = this.dataSource.getFirstLeafPath();
            long lastLeafPath = this.dataSource.getLastLeafPath();
            int leafCount = Math.toIntExact(lastLeafPath - firstLeafPath + 1L);
            System.out.printf("Validating %,d internal node hashes...%n", firstLeafPath);
            this.progressPercentage = 0;
            for (path = 0L; path < firstLeafPath; ++path) {
                Hash hash = this.dataSource.loadHash(path);
                DataSourceValidator.assertTrue(hash != null, "internal record's hash for path [" + path + "] was null");
                this.printProgress(path, firstLeafPath);
            }
            System.out.println("All internal node hashes are valid :-)" + WHITESPACE);
            System.out.printf("Validating %,d leaf hashes...%n", firstLeafPath);
            this.progressPercentage = 0;
            for (path = firstLeafPath; path <= lastLeafPath; ++path) {
                Hash leafHash = this.dataSource.loadHash(path);
                DataSourceValidator.assertTrue(leafHash == null, "leaf record's hash for path [" + path + "] was not null");
                this.printProgress(path - firstLeafPath, leafCount);
            }
            System.out.println("All leaf hashes are null :-)" + WHITESPACE);
            System.out.printf("Validating %,d leaf record by path...%n", firstLeafPath);
            ArrayList<Bytes> keys = new ArrayList<Bytes>(leafCount);
            this.progressPercentage = 0;
            for (long path2 = firstLeafPath; path2 <= lastLeafPath; ++path2) {
                VirtualLeafBytes<?> leaf = this.dataSource.loadLeafRecord(path2);
                DataSourceValidator.assertTrue(leaf != null, "leaf record for path [" + path2 + "] was null");
                DataSourceValidator.assertTrue(leaf.path() == path2, "leaf record for path [" + path2 + "] had a bad path [" + leaf.path() + "]");
                DataSourceValidator.assertTrue(leaf.keyBytes().length() > 0L, "leaf record's key for path [" + path2 + "] was empty");
                keys.add(leaf.keyBytes());
                this.printProgress(path2 - firstLeafPath, leafCount);
            }
            System.out.println("All leaf record by path are valid :-)" + WHITESPACE);
            System.out.printf("Validating %,d leaf record by key...%n", leafCount);
            this.progressPercentage = 0;
            for (int i = 0; i < keys.size(); ++i) {
                VirtualLeafBytes<?> leaf = this.dataSource.loadLeafRecord((Bytes)keys.get(i));
                DataSourceValidator.assertTrue(leaf != null, "leaf record for key [" + String.valueOf(keys.get(i)) + "] was null");
                DataSourceValidator.assertTrue(leaf.keyBytes().length() > 0L, "leaf record's key for key [" + String.valueOf(keys.get(i)) + "] was empty");
                DataSourceValidator.assertTrue(leaf.keyBytes().equals(keys.get(i)), "leaf record's key for key [" + String.valueOf(keys.get(i)) + "] did not match, it was [" + String.valueOf(leaf.keyBytes()) + "]");
                this.printProgress(i, keys.size());
            }
            System.out.println("All leaf record by key are valid :-)" + WHITESPACE);
            System.out.println("YAY all data is good!");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static void assertTrue(boolean testResult, String message) {
        if (!testResult) {
            throw new IllegalStateException(message);
        }
    }

    private void printProgress(long position, long total) {
        assert (position >= 0L) : "position [" + position + "] is < 0";
        assert (total > 0L) : "total [" + total + "] is <= 0";
        int newProgressPercentage = (int)((double)position / (double)total * 20.0);
        assert (newProgressPercentage >= 0) : "newProgressPercentage [" + newProgressPercentage + "] is < 0";
        assert (newProgressPercentage <= 20) : "newProgressPercentage [" + newProgressPercentage + "] is > 20, position=" + position + ", total=" + total;
        if (newProgressPercentage > this.progressPercentage) {
            this.progressPercentage = newProgressPercentage;
            System.out.printf("[%s] %d%%, %,d of %,d\r", "#".repeat(newProgressPercentage) + " ".repeat(20 - newProgressPercentage), this.progressPercentage * 5, position, total);
        }
    }
}

