/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.utility;

import com.swirlds.common.FastCopyable;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public abstract class AbstractListLeaf<T extends FastCopyable & SelfSerializable>
extends PartialMerkleLeaf
implements List<T>,
MerkleLeaf {
    protected List<T> elements;

    protected AbstractListLeaf() {
        this.elements = new ArrayList<T>();
    }

    protected AbstractListLeaf(List<T> elements) {
        if (elements.size() > this.getMaxSize()) {
            throw new IllegalArgumentException("Provided list exceeds maximum size");
        }
        this.elements = new ArrayList<T>(elements.size());
        for (FastCopyable element : elements) {
            this.elements.add((FastCopyable)element.copy());
        }
    }

    protected AbstractListLeaf(AbstractListLeaf<T> that) {
        super(that);
        this.elements = new ArrayList<T>(that.elements.size());
        for (FastCopyable element : that.elements) {
            this.elements.add((FastCopyable)element.copy());
        }
    }

    public AbstractListLeaf(int initialSize) {
        this.elements = new ArrayList<T>(initialSize);
    }

    protected int getMaxSize() {
        return Integer.MAX_VALUE;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeSerializableList(this.elements, true, false);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.elements = in.readSerializableList(this.getMaxSize());
    }

    public final int getVersion() {
        return 1;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.elements.toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.elements.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.elements.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.elements.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.elements.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.elements.retainAll(c);
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public T get(int index) {
        return (T)((FastCopyable)this.elements.get(index));
    }

    @Override
    public T set(int index, T element) {
        return (T)((FastCopyable)this.elements.set(index, element));
    }

    @Override
    public void add(int index, T element) {
        this.elements.add(index, element);
    }

    @Override
    public T remove(int index) {
        return (T)((FastCopyable)this.elements.remove(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.elements.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.elements.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.elements.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.elements.subList(fromIndex, toIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("List size: ").append(this.elements.size());
        sb.append(" [");
        for (int index = 0; index < this.elements.size(); ++index) {
            FastCopyable element = (FastCopyable)this.elements.get(index);
            sb.append(element == null ? "null" : element.toString());
            if (index + 1 >= this.elements.size()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public abstract AbstractListLeaf<T> copy();

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

