/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.merkle.map;

import com.swirlds.demo.merkle.map.FCMSequential;
import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.virtualmerkle.config.TransactionRequestConfig;
import com.swirlds.demo.virtualmerkle.config.VirtualMerkleConfig;
import com.swirlds.merkle.test.fixtures.map.lifecycle.EntityType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class FCMConfig
implements Serializable {
    private boolean disableExpectedMap = false;
    private boolean sequentialTest = true;
    private ArrayList<Long>[] nodeList = null;
    private ArrayList<Long>[] tpsList = null;
    private FCMQueryConfig fcmQueryConfig;
    private FCMSequential[] sequentials;
    private double nftTrackingFraction = 1.0E-4;
    private int csvUpdatePeriod = 1000;
    private Map<EntityType, Integer> expectedEntityAmountForTypePerNode;
    private int expectedEntityAmountTotalPerNode;
    private int initialRecordNum;

    public int getInitialRecordNum() {
        return this.initialRecordNum;
    }

    public void setInitialRecordNum(int initialRecordNum) {
        this.initialRecordNum = initialRecordNum;
    }

    public boolean isSequentialTest() {
        return this.sequentialTest;
    }

    public void setSequentialTest(boolean sequentialTest) {
        this.sequentialTest = sequentialTest;
    }

    public boolean isDisableExpectedMap() {
        return this.disableExpectedMap;
    }

    public void setDisableExpectedMap(boolean disableExpectedMap) {
        this.disableExpectedMap = disableExpectedMap;
    }

    public int getCsvUpdatePeriod() {
        return this.csvUpdatePeriod;
    }

    public void setCsvUpdatePeriod(int csvUpdatePeriod) {
        this.csvUpdatePeriod = csvUpdatePeriod;
    }

    public long getTranAmountByType(PAYLOAD_TYPE type) {
        if (this.sequentials == null) {
            return 0L;
        }
        return Arrays.stream(this.sequentials).filter(o -> o.getSequentialType() == type).mapToInt(FCMSequential::getSequentialAmount).sum();
    }

    public ArrayList<Long>[] getNodeList() {
        return this.nodeList;
    }

    public void setNodeList(ArrayList<Long>[] nodeList) {
        this.nodeList = nodeList;
    }

    public ArrayList<Long>[] getTpsList() {
        return this.tpsList;
    }

    public void setTpsList(ArrayList<Long>[] tpsList) {
        this.tpsList = tpsList;
    }

    public FCMSequential[] getSequentials() {
        if (this.sequentials == null) {
            this.sequentials = new FCMSequential[0];
        }
        return this.sequentials;
    }

    public void setSequentials(FCMSequential[] sequentials) {
        this.sequentials = sequentials;
    }

    public FCMQueryConfig getFcmQueryConfig() {
        return this.fcmQueryConfig;
    }

    public void setFcmQueryConfig(FCMQueryConfig fcmQueryConfig) {
        this.fcmQueryConfig = fcmQueryConfig;
    }

    public void loadSequentials() {
        this.expectedEntityAmountForTypePerNode = new HashMap<EntityType, Integer>();
        if (this.sequentials == null || this.sequentials.length < 1) {
            return;
        }
        for (FCMSequential sequential : this.sequentials) {
            this.addExpectedEntityAmount(sequential.getSequentialType(), sequential.getSequentialAmount());
        }
    }

    public void addExpectedEntityAmount(PAYLOAD_TYPE payloadType, int amount) {
        if (!payloadType.name().contains("CREATE")) {
            return;
        }
        EntityType entityType = null;
        if (payloadType.name().contains("FCQ")) {
            entityType = EntityType.FCQ;
        } else if (payloadType.equals((Object)PAYLOAD_TYPE.TYPE_FCM_CREATE)) {
            entityType = EntityType.Crypto;
        } else if (payloadType.equals((Object)PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_CREATE)) {
            entityType = EntityType.VIRTUAL_MERKLE_ACCOUNT;
        } else {
            return;
        }
        int currentAmount = this.expectedEntityAmountForTypePerNode.getOrDefault(entityType, 0);
        this.expectedEntityAmountForTypePerNode.put(entityType, currentAmount + amount);
        this.expectedEntityAmountTotalPerNode += amount;
    }

    public void loadVirtualMerkleSequentials(VirtualMerkleConfig virtualMerkleConfig) {
        if (virtualMerkleConfig == null) {
            return;
        }
        long maxAccounts = 0L;
        long accumulatedAccounts = 0L;
        for (TransactionRequestConfig t : virtualMerkleConfig.getSequential()) {
            if (t.getType() == PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_CREATE) {
                maxAccounts = Math.max(maxAccounts, accumulatedAccounts += t.getAmount());
                continue;
            }
            if (t.getType() != PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_DELETE) continue;
            accumulatedAccounts -= t.getAmount();
        }
        int expectedNumberOfEntities = (int)((double)maxAccounts * virtualMerkleConfig.getSamplingProbability() + 1.0);
        this.addExpectedEntityAmount(PAYLOAD_TYPE.TYPE_VIRTUAL_MERKLE_CREATE, expectedNumberOfEntities);
    }

    public int getExpectedEntityAmountForTypePerNode(EntityType entityType) {
        return this.expectedEntityAmountForTypePerNode.getOrDefault(entityType, 0);
    }

    public int getExpectedEntityAmountTotalPerNode() {
        return this.expectedEntityAmountTotalPerNode;
    }

    public PAYLOAD_TYPE getSequentialType(int index) {
        if (index >= this.sequentials.length) {
            return PAYLOAD_TYPE.TYPE_RANDOM_BYTES;
        }
        return this.sequentials[index].getSequentialType();
    }

    public int getSequentialSize(int index) {
        if (index >= this.sequentials.length) {
            return 100;
        }
        return this.sequentials[index].getSequentialSize();
    }

    public int getSequentialAmount(int index) {
        if (index >= this.sequentials.length) {
            return 1;
        }
        return this.sequentials[index].getSequentialAmount();
    }

    public double getNftTrackingFraction() {
        return this.nftTrackingFraction;
    }

    public void setNftTrackingFraction(double nftTrackingFraction) {
        this.nftTrackingFraction = nftTrackingFraction;
    }

    public static class FCMQueryConfig {
        private int qps;
        private int numberOfThreads = 1;

        public int getQps() {
            return this.qps;
        }

        public void setQps(int tps) {
            this.qps = tps;
        }

        public int getNumberOfThreads() {
            return this.numberOfThreads;
        }

        public void setNumberOfThreads(int numberOfThreads) {
            this.numberOfThreads = numberOfThreads;
        }
    }
}

