/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenAssociation;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.hapi.node.transaction.PendingAirdropRecord;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.codec.TransactionRecordJsonCodec;
import com.hedera.hapi.node.transaction.codec.TransactionRecordProtoCodec;
import com.hedera.hapi.node.transaction.schema.TransactionRecordSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class TransactionRecord {
    public static final Codec<TransactionRecord> PROTOBUF = new TransactionRecordProtoCodec();
    public static final JsonCodec<TransactionRecord> JSON = new TransactionRecordJsonCodec();
    public static final TransactionRecord DEFAULT = TransactionRecord.newBuilder().build();
    @Nullable
    private final TransactionReceipt receipt;
    @NonNull
    private final Bytes transactionHash;
    @Nullable
    private final Timestamp consensusTimestamp;
    @Nullable
    private final TransactionID transactionID;
    @NonNull
    private final String memo;
    private final long transactionFee;
    private final OneOf<BodyOneOfType> body;
    @Nullable
    private final TransferList transferList;
    @NonNull
    private final List<TokenTransferList> tokenTransferLists;
    @Nullable
    private final ScheduleID scheduleRef;
    @NonNull
    private final List<AssessedCustomFee> assessedCustomFees;
    @NonNull
    private final List<TokenAssociation> automaticTokenAssociations;
    @Nullable
    private final Timestamp parentConsensusTimestamp;
    @NonNull
    private final Bytes alias;
    @NonNull
    private final Bytes ethereumHash;
    @NonNull
    private final List<AccountAmount> paidStakingRewards;
    private final OneOf<EntropyOneOfType> entropy;
    @NonNull
    private final Bytes evmAddress;
    @NonNull
    private final List<PendingAirdropRecord> newPendingAirdrops;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public TransactionRecord(TransactionReceipt receipt, Bytes transactionHash, Timestamp consensusTimestamp, TransactionID transactionID, String memo, long transactionFee, OneOf<BodyOneOfType> body, TransferList transferList, List<TokenTransferList> tokenTransferLists, ScheduleID scheduleRef, List<AssessedCustomFee> assessedCustomFees, List<TokenAssociation> automaticTokenAssociations, Timestamp parentConsensusTimestamp, Bytes alias, Bytes ethereumHash, List<AccountAmount> paidStakingRewards, OneOf<EntropyOneOfType> entropy, Bytes evmAddress, List<PendingAirdropRecord> newPendingAirdrops) {
        this.$unknownFields = null;
        this.receipt = receipt;
        this.transactionHash = transactionHash != null ? transactionHash : Bytes.EMPTY;
        this.consensusTimestamp = consensusTimestamp;
        this.transactionID = transactionID;
        this.memo = memo != null ? memo : "";
        this.transactionFee = transactionFee;
        if (body == null) {
            throw new NullPointerException("Parameter 'body' must be supplied and can not be null");
        }
        this.body = body;
        this.transferList = transferList;
        this.tokenTransferLists = tokenTransferLists == null ? Collections.emptyList() : tokenTransferLists;
        this.scheduleRef = scheduleRef;
        this.assessedCustomFees = assessedCustomFees == null ? Collections.emptyList() : assessedCustomFees;
        this.automaticTokenAssociations = automaticTokenAssociations == null ? Collections.emptyList() : automaticTokenAssociations;
        this.parentConsensusTimestamp = parentConsensusTimestamp;
        this.alias = alias != null ? alias : Bytes.EMPTY;
        this.ethereumHash = ethereumHash != null ? ethereumHash : Bytes.EMPTY;
        List<Object> list = this.paidStakingRewards = paidStakingRewards == null ? Collections.emptyList() : paidStakingRewards;
        if (entropy == null) {
            throw new NullPointerException("Parameter 'entropy' must be supplied and can not be null");
        }
        this.entropy = entropy;
        this.evmAddress = evmAddress != null ? evmAddress : Bytes.EMPTY;
        this.newPendingAirdrops = newPendingAirdrops == null ? Collections.emptyList() : newPendingAirdrops;
    }

    public TransactionRecord(TransactionReceipt receipt, Bytes transactionHash, Timestamp consensusTimestamp, TransactionID transactionID, String memo, long transactionFee, OneOf<BodyOneOfType> body, TransferList transferList, List<TokenTransferList> tokenTransferLists, ScheduleID scheduleRef, List<AssessedCustomFee> assessedCustomFees, List<TokenAssociation> automaticTokenAssociations, Timestamp parentConsensusTimestamp, Bytes alias, Bytes ethereumHash, List<AccountAmount> paidStakingRewards, OneOf<EntropyOneOfType> entropy, Bytes evmAddress, List<PendingAirdropRecord> newPendingAirdrops, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.receipt = receipt;
        this.transactionHash = transactionHash != null ? transactionHash : Bytes.EMPTY;
        this.consensusTimestamp = consensusTimestamp;
        this.transactionID = transactionID;
        this.memo = memo != null ? memo : "";
        this.transactionFee = transactionFee;
        if (body == null) {
            throw new NullPointerException("Parameter 'body' must be supplied and can not be null");
        }
        this.body = body;
        this.transferList = transferList;
        this.tokenTransferLists = tokenTransferLists == null ? Collections.emptyList() : tokenTransferLists;
        this.scheduleRef = scheduleRef;
        this.assessedCustomFees = assessedCustomFees == null ? Collections.emptyList() : assessedCustomFees;
        this.automaticTokenAssociations = automaticTokenAssociations == null ? Collections.emptyList() : automaticTokenAssociations;
        this.parentConsensusTimestamp = parentConsensusTimestamp;
        this.alias = alias != null ? alias : Bytes.EMPTY;
        this.ethereumHash = ethereumHash != null ? ethereumHash : Bytes.EMPTY;
        List<Object> list = this.paidStakingRewards = paidStakingRewards == null ? Collections.emptyList() : paidStakingRewards;
        if (entropy == null) {
            throw new NullPointerException("Parameter 'entropy' must be supplied and can not be null");
        }
        this.entropy = entropy;
        this.evmAddress = evmAddress != null ? evmAddress : Bytes.EMPTY;
        this.newPendingAirdrops = newPendingAirdrops == null ? Collections.emptyList() : newPendingAirdrops;
    }

    public TransactionReceipt receipt() {
        return this.receipt;
    }

    public Bytes transactionHash() {
        return this.transactionHash;
    }

    public Timestamp consensusTimestamp() {
        return this.consensusTimestamp;
    }

    public TransactionID transactionID() {
        return this.transactionID;
    }

    public String memo() {
        return this.memo;
    }

    public long transactionFee() {
        return this.transactionFee;
    }

    public OneOf<BodyOneOfType> body() {
        return this.body;
    }

    public TransferList transferList() {
        return this.transferList;
    }

    public List<TokenTransferList> tokenTransferLists() {
        return this.tokenTransferLists;
    }

    public ScheduleID scheduleRef() {
        return this.scheduleRef;
    }

    public List<AssessedCustomFee> assessedCustomFees() {
        return this.assessedCustomFees;
    }

    public List<TokenAssociation> automaticTokenAssociations() {
        return this.automaticTokenAssociations;
    }

    public Timestamp parentConsensusTimestamp() {
        return this.parentConsensusTimestamp;
    }

    public Bytes alias() {
        return this.alias;
    }

    public Bytes ethereumHash() {
        return this.ethereumHash;
    }

    public List<AccountAmount> paidStakingRewards() {
        return this.paidStakingRewards;
    }

    public OneOf<EntropyOneOfType> entropy() {
        return this.entropy;
    }

    public Bytes evmAddress() {
        return this.evmAddress;
    }

    public List<PendingAirdropRecord> newPendingAirdrops() {
        return this.newPendingAirdrops;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.RECEIPT, (Object)this.receipt, TransactionReceipt.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.TRANSACTION_HASH, (RandomAccessData)this.transactionHash, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.CONSENSUS_TIMESTAMP, (Object)this.consensusTimestamp, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.TRANSACTION_ID, (Object)this.transactionID, TransactionID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)TransactionRecordSchema.MEMO, (String)this.memo, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)TransactionRecordSchema.TRANSACTION_FEE, (long)this.transactionFee, (boolean)true);
            if (this.body.kind() == BodyOneOfType.CONTRACT_CALL_RESULT) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.CONTRACT_CALL_RESULT, (Object)((ContractFunctionResult)this.body.as()), ContractFunctionResult.PROTOBUF);
            }
            if (this.body.kind() == BodyOneOfType.CONTRACT_CREATE_RESULT) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.CONTRACT_CREATE_RESULT, (Object)((ContractFunctionResult)this.body.as()), ContractFunctionResult.PROTOBUF);
            }
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.TRANSFER_LIST, (Object)this.transferList, TransferList.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TransactionRecordSchema.TOKEN_TRANSFER_LISTS, this.tokenTransferLists, TokenTransferList.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.SCHEDULE_REF, (Object)this.scheduleRef, ScheduleID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TransactionRecordSchema.ASSESSED_CUSTOM_FEES, this.assessedCustomFees, AssessedCustomFee.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TransactionRecordSchema.AUTOMATIC_TOKEN_ASSOCIATIONS, this.automaticTokenAssociations, TokenAssociation.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.PARENT_CONSENSUS_TIMESTAMP, (Object)this.parentConsensusTimestamp, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.ALIAS, (RandomAccessData)this.alias, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.ETHEREUM_HASH, (RandomAccessData)this.ethereumHash, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TransactionRecordSchema.PAID_STAKING_REWARDS, this.paidStakingRewards, AccountAmount.PROTOBUF);
            if (this.entropy.kind() == EntropyOneOfType.PRNG_BYTES) {
                _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.PRNG_BYTES, (RandomAccessData)((RandomAccessData)this.entropy.as()), (boolean)true);
            }
            if (this.entropy.kind() == EntropyOneOfType.PRNG_NUMBER) {
                _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)TransactionRecordSchema.PRNG_NUMBER, (int)((Integer)this.entropy.as()), (boolean)true);
            }
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.EVM_ADDRESS, (RandomAccessData)this.evmAddress, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TransactionRecordSchema.NEW_PENDING_AIRDROPS, this.newPendingAirdrops, PendingAirdropRecord.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        if (this.$hashCode == -1) {
            List<PendingAirdropRecord> list;
            List<AccountAmount> list2;
            List<TokenAssociation> list3;
            List<AssessedCustomFee> list$assessedCustomFees;
            List<TokenTransferList> list$tokenTransferLists;
            int result = 1;
            if (this.receipt != null && !this.receipt.equals(TransactionRecord.DEFAULT.receipt)) {
                result = 31 * result + this.receipt.hashCode();
            }
            if (this.transactionHash != null && !this.transactionHash.equals((Object)TransactionRecord.DEFAULT.transactionHash)) {
                result = 31 * result + this.transactionHash.hashCode();
            }
            if (this.consensusTimestamp != null && !this.consensusTimestamp.equals(TransactionRecord.DEFAULT.consensusTimestamp)) {
                result = 31 * result + this.consensusTimestamp.hashCode();
            }
            if (this.transactionID != null && !this.transactionID.equals(TransactionRecord.DEFAULT.transactionID)) {
                result = 31 * result + this.transactionID.hashCode();
            }
            if (this.memo != null && !this.memo.equals(TransactionRecord.DEFAULT.memo)) {
                result = 31 * result + this.memo.hashCode();
            }
            if (this.transactionFee != TransactionRecord.DEFAULT.transactionFee) {
                result = 31 * result + Long.hashCode(this.transactionFee);
            }
            if (this.body != null && !this.body.equals(TransactionRecord.DEFAULT.body)) {
                result = 31 * result + this.body.hashCode();
            }
            if (this.transferList != null && !this.transferList.equals(TransactionRecord.DEFAULT.transferList)) {
                result = 31 * result + this.transferList.hashCode();
            }
            if ((list$tokenTransferLists = this.tokenTransferLists) != null) {
                for (TokenTransferList tokenTransferList : list$tokenTransferLists) {
                    if (tokenTransferList != null) {
                        result = 31 * result + ((Object)tokenTransferList).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.scheduleRef != null && !this.scheduleRef.equals(TransactionRecord.DEFAULT.scheduleRef)) {
                result = 31 * result + this.scheduleRef.hashCode();
            }
            if ((list$assessedCustomFees = this.assessedCustomFees) != null) {
                for (AssessedCustomFee assessedCustomFee : list$assessedCustomFees) {
                    if (assessedCustomFee != null) {
                        result = 31 * result + ((Object)assessedCustomFee).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if ((list3 = this.automaticTokenAssociations) != null) {
                for (TokenAssociation tokenAssociation : list3) {
                    if (tokenAssociation != null) {
                        result = 31 * result + ((Object)tokenAssociation).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.parentConsensusTimestamp != null && !this.parentConsensusTimestamp.equals(TransactionRecord.DEFAULT.parentConsensusTimestamp)) {
                result = 31 * result + this.parentConsensusTimestamp.hashCode();
            }
            if (this.alias != null && !this.alias.equals((Object)TransactionRecord.DEFAULT.alias)) {
                result = 31 * result + this.alias.hashCode();
            }
            if (this.ethereumHash != null && !this.ethereumHash.equals((Object)TransactionRecord.DEFAULT.ethereumHash)) {
                result = 31 * result + this.ethereumHash.hashCode();
            }
            if ((list2 = this.paidStakingRewards) != null) {
                for (AccountAmount accountAmount : list2) {
                    if (accountAmount != null) {
                        result = 31 * result + ((Object)accountAmount).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.entropy != null && !this.entropy.equals(TransactionRecord.DEFAULT.entropy)) {
                result = 31 * result + this.entropy.hashCode();
            }
            if (this.evmAddress != null && !this.evmAddress.equals((Object)TransactionRecord.DEFAULT.evmAddress)) {
                result = 31 * result + this.evmAddress.hashCode();
            }
            if ((list = this.newPendingAirdrops) != null) {
                for (PendingAirdropRecord pendingAirdropRecord : list) {
                    if (pendingAirdropRecord != null) {
                        result = 31 * result + ((Object)pendingAirdropRecord).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.$unknownFields != null) {
                void var7_20;
                boolean bl = false;
                while (var7_20 < this.$unknownFields.size()) {
                    result = 31 * result + this.$unknownFields.get((int)var7_20).hashCode();
                    ++var7_20;
                }
            }
            long l = result;
            l += l << 30;
            l ^= l >>> 27;
            l += l << 16;
            l ^= l >>> 20;
            l += l << 5;
            l ^= l >>> 18;
            l += l << 10;
            l ^= l >>> 24;
            l += l << 30;
            this.$hashCode = (int)l;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TransactionRecord thatObj = (TransactionRecord)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.receipt == null && thatObj.receipt != null) {
            return false;
        }
        if (this.receipt != null && !this.receipt.equals(thatObj.receipt)) {
            return false;
        }
        if (this.transactionHash == null && thatObj.transactionHash != null) {
            return false;
        }
        if (this.transactionHash != null && !this.transactionHash.equals((Object)thatObj.transactionHash)) {
            return false;
        }
        if (this.consensusTimestamp == null && thatObj.consensusTimestamp != null) {
            return false;
        }
        if (this.consensusTimestamp != null && !this.consensusTimestamp.equals(thatObj.consensusTimestamp)) {
            return false;
        }
        if (this.transactionID == null && thatObj.transactionID != null) {
            return false;
        }
        if (this.transactionID != null && !this.transactionID.equals(thatObj.transactionID)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.transactionFee != thatObj.transactionFee) {
            return false;
        }
        if (this.body == null && thatObj.body != null) {
            return false;
        }
        if (this.body != null && !this.body.equals(thatObj.body)) {
            return false;
        }
        if (this.transferList == null && thatObj.transferList != null) {
            return false;
        }
        if (this.transferList != null && !this.transferList.equals(thatObj.transferList)) {
            return false;
        }
        if (this.tokenTransferLists == null && thatObj.tokenTransferLists != null) {
            return false;
        }
        if (this.tokenTransferLists != null && !this.tokenTransferLists.equals(thatObj.tokenTransferLists)) {
            return false;
        }
        if (this.scheduleRef == null && thatObj.scheduleRef != null) {
            return false;
        }
        if (this.scheduleRef != null && !this.scheduleRef.equals(thatObj.scheduleRef)) {
            return false;
        }
        if (this.assessedCustomFees == null && thatObj.assessedCustomFees != null) {
            return false;
        }
        if (this.assessedCustomFees != null && !this.assessedCustomFees.equals(thatObj.assessedCustomFees)) {
            return false;
        }
        if (this.automaticTokenAssociations == null && thatObj.automaticTokenAssociations != null) {
            return false;
        }
        if (this.automaticTokenAssociations != null && !this.automaticTokenAssociations.equals(thatObj.automaticTokenAssociations)) {
            return false;
        }
        if (this.parentConsensusTimestamp == null && thatObj.parentConsensusTimestamp != null) {
            return false;
        }
        if (this.parentConsensusTimestamp != null && !this.parentConsensusTimestamp.equals(thatObj.parentConsensusTimestamp)) {
            return false;
        }
        if (this.alias == null && thatObj.alias != null) {
            return false;
        }
        if (this.alias != null && !this.alias.equals((Object)thatObj.alias)) {
            return false;
        }
        if (this.ethereumHash == null && thatObj.ethereumHash != null) {
            return false;
        }
        if (this.ethereumHash != null && !this.ethereumHash.equals((Object)thatObj.ethereumHash)) {
            return false;
        }
        if (this.paidStakingRewards == null && thatObj.paidStakingRewards != null) {
            return false;
        }
        if (this.paidStakingRewards != null && !this.paidStakingRewards.equals(thatObj.paidStakingRewards)) {
            return false;
        }
        if (this.entropy == null && thatObj.entropy != null) {
            return false;
        }
        if (this.entropy != null && !this.entropy.equals(thatObj.entropy)) {
            return false;
        }
        if (this.evmAddress == null && thatObj.evmAddress != null) {
            return false;
        }
        if (this.evmAddress != null && !this.evmAddress.equals((Object)thatObj.evmAddress)) {
            return false;
        }
        if (this.newPendingAirdrops == null && thatObj.newPendingAirdrops != null) {
            return false;
        }
        if (this.newPendingAirdrops != null && !this.newPendingAirdrops.equals(thatObj.newPendingAirdrops)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "TransactionRecord[receipt=" + String.valueOf(this.receipt) + ", transactionHash=" + String.valueOf(this.transactionHash) + ", consensusTimestamp=" + String.valueOf(this.consensusTimestamp) + ", transactionID=" + String.valueOf(this.transactionID) + ", memo=" + this.memo + ", transactionFee=" + this.transactionFee + ", body=" + String.valueOf(this.body) + ", transferList=" + String.valueOf(this.transferList) + ", tokenTransferLists=" + String.valueOf(this.tokenTransferLists) + ", scheduleRef=" + String.valueOf(this.scheduleRef) + ", assessedCustomFees=" + String.valueOf(this.assessedCustomFees) + ", automaticTokenAssociations=" + String.valueOf(this.automaticTokenAssociations) + ", parentConsensusTimestamp=" + String.valueOf(this.parentConsensusTimestamp) + ", alias=" + String.valueOf(this.alias) + ", ethereumHash=" + String.valueOf(this.ethereumHash) + ", paidStakingRewards=" + String.valueOf(this.paidStakingRewards) + ", entropy=" + String.valueOf(this.entropy) + ", evmAddress=" + String.valueOf(this.evmAddress) + ", newPendingAirdrops=" + String.valueOf(this.newPendingAirdrops) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasReceipt() {
        return this.receipt != null;
    }

    public TransactionReceipt receiptOrElse(@NonNull TransactionReceipt defaultValue) {
        return this.hasReceipt() ? this.receipt : defaultValue;
    }

    @NonNull
    public TransactionReceipt receiptOrThrow() {
        return Objects.requireNonNull(this.receipt, "Field receipt is null");
    }

    public void ifReceipt(@NonNull Consumer<TransactionReceipt> ifPresent) {
        if (this.hasReceipt()) {
            ifPresent.accept(this.receipt);
        }
    }

    public boolean hasConsensusTimestamp() {
        return this.consensusTimestamp != null;
    }

    public Timestamp consensusTimestampOrElse(@NonNull Timestamp defaultValue) {
        return this.hasConsensusTimestamp() ? this.consensusTimestamp : defaultValue;
    }

    @NonNull
    public Timestamp consensusTimestampOrThrow() {
        return Objects.requireNonNull(this.consensusTimestamp, "Field consensusTimestamp is null");
    }

    public void ifConsensusTimestamp(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasConsensusTimestamp()) {
            ifPresent.accept(this.consensusTimestamp);
        }
    }

    public boolean hasTransactionID() {
        return this.transactionID != null;
    }

    public TransactionID transactionIDOrElse(@NonNull TransactionID defaultValue) {
        return this.hasTransactionID() ? this.transactionID : defaultValue;
    }

    @NonNull
    public TransactionID transactionIDOrThrow() {
        return Objects.requireNonNull(this.transactionID, "Field transactionID is null");
    }

    public void ifTransactionID(@NonNull Consumer<TransactionID> ifPresent) {
        if (this.hasTransactionID()) {
            ifPresent.accept(this.transactionID);
        }
    }

    public boolean hasTransferList() {
        return this.transferList != null;
    }

    public TransferList transferListOrElse(@NonNull TransferList defaultValue) {
        return this.hasTransferList() ? this.transferList : defaultValue;
    }

    @NonNull
    public TransferList transferListOrThrow() {
        return Objects.requireNonNull(this.transferList, "Field transferList is null");
    }

    public void ifTransferList(@NonNull Consumer<TransferList> ifPresent) {
        if (this.hasTransferList()) {
            ifPresent.accept(this.transferList);
        }
    }

    public boolean hasScheduleRef() {
        return this.scheduleRef != null;
    }

    public ScheduleID scheduleRefOrElse(@NonNull ScheduleID defaultValue) {
        return this.hasScheduleRef() ? this.scheduleRef : defaultValue;
    }

    @NonNull
    public ScheduleID scheduleRefOrThrow() {
        return Objects.requireNonNull(this.scheduleRef, "Field scheduleRef is null");
    }

    public void ifScheduleRef(@NonNull Consumer<ScheduleID> ifPresent) {
        if (this.hasScheduleRef()) {
            ifPresent.accept(this.scheduleRef);
        }
    }

    public boolean hasParentConsensusTimestamp() {
        return this.parentConsensusTimestamp != null;
    }

    public Timestamp parentConsensusTimestampOrElse(@NonNull Timestamp defaultValue) {
        return this.hasParentConsensusTimestamp() ? this.parentConsensusTimestamp : defaultValue;
    }

    @NonNull
    public Timestamp parentConsensusTimestampOrThrow() {
        return Objects.requireNonNull(this.parentConsensusTimestamp, "Field parentConsensusTimestamp is null");
    }

    public void ifParentConsensusTimestamp(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasParentConsensusTimestamp()) {
            ifPresent.accept(this.parentConsensusTimestamp);
        }
    }

    @Nullable
    public ContractFunctionResult contractCallResult() {
        return this.body.kind() == BodyOneOfType.CONTRACT_CALL_RESULT ? (ContractFunctionResult)this.body.value() : null;
    }

    public boolean hasContractCallResult() {
        return this.body.kind() == BodyOneOfType.CONTRACT_CALL_RESULT;
    }

    public ContractFunctionResult contractCallResultOrElse(@NonNull ContractFunctionResult defaultValue) {
        return this.hasContractCallResult() ? this.contractCallResult() : defaultValue;
    }

    @NonNull
    public ContractFunctionResult contractCallResultOrThrow() {
        return Objects.requireNonNull(this.contractCallResult(), "Field contractCallResult is null");
    }

    @Nullable
    public ContractFunctionResult contractCreateResult() {
        return this.body.kind() == BodyOneOfType.CONTRACT_CREATE_RESULT ? (ContractFunctionResult)this.body.value() : null;
    }

    public boolean hasContractCreateResult() {
        return this.body.kind() == BodyOneOfType.CONTRACT_CREATE_RESULT;
    }

    public ContractFunctionResult contractCreateResultOrElse(@NonNull ContractFunctionResult defaultValue) {
        return this.hasContractCreateResult() ? this.contractCreateResult() : defaultValue;
    }

    @NonNull
    public ContractFunctionResult contractCreateResultOrThrow() {
        return Objects.requireNonNull(this.contractCreateResult(), "Field contractCreateResult is null");
    }

    @Nullable
    public Bytes prngBytes() {
        return this.entropy.kind() == EntropyOneOfType.PRNG_BYTES ? (Bytes)this.entropy.value() : null;
    }

    public boolean hasPrngBytes() {
        return this.entropy.kind() == EntropyOneOfType.PRNG_BYTES;
    }

    public Bytes prngBytesOrElse(@NonNull Bytes defaultValue) {
        return this.hasPrngBytes() ? this.prngBytes() : defaultValue;
    }

    @NonNull
    public Bytes prngBytesOrThrow() {
        return Objects.requireNonNull(this.prngBytes(), "Field prngBytes is null");
    }

    @Nullable
    public Integer prngNumber() {
        return this.entropy.kind() == EntropyOneOfType.PRNG_NUMBER ? (Integer)this.entropy.value() : null;
    }

    public boolean hasPrngNumber() {
        return this.entropy.kind() == EntropyOneOfType.PRNG_NUMBER;
    }

    public Integer prngNumberOrElse(@NonNull Integer defaultValue) {
        return this.hasPrngNumber() ? this.prngNumber() : defaultValue;
    }

    @NonNull
    public Integer prngNumberOrThrow() {
        return Objects.requireNonNull(this.prngNumber(), "Field prngNumber is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.receipt, this.transactionHash, this.consensusTimestamp, this.transactionID, this.memo, this.transactionFee, this.body, this.transferList, this.tokenTransferLists, this.scheduleRef, this.assessedCustomFees, this.automaticTokenAssociations, this.parentConsensusTimestamp, this.alias, this.ethereumHash, this.paidStakingRewards, this.entropy, this.evmAddress, this.newPendingAirdrops, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum BodyOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        CONTRACT_CALL_RESULT(7, "contractCallResult"),
        CONTRACT_CREATE_RESULT(8, "contractCreateResult");

        private final int protoOrdinal;
        private final String protoName;

        private BodyOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static BodyOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 7 -> CONTRACT_CALL_RESULT;
                case 8 -> CONTRACT_CREATE_RESULT;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static BodyOneOfType fromString(String name) {
            return switch (name) {
                case "contractCallResult", "CONTRACT_CALL_RESULT" -> CONTRACT_CALL_RESULT;
                case "contractCreateResult", "CONTRACT_CREATE_RESULT" -> CONTRACT_CREATE_RESULT;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static enum EntropyOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        PRNG_BYTES(19, "prng_bytes"),
        PRNG_NUMBER(20, "prng_number");

        private final int protoOrdinal;
        private final String protoName;

        private EntropyOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static EntropyOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 19 -> PRNG_BYTES;
                case 20 -> PRNG_NUMBER;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static EntropyOneOfType fromString(String name) {
            return switch (name) {
                case "prng_bytes", "PRNG_BYTES" -> PRNG_BYTES;
                case "prng_number", "PRNG_NUMBER" -> PRNG_NUMBER;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        @Nullable
        private TransactionReceipt receipt = null;
        @NonNull
        private Bytes transactionHash = Bytes.EMPTY;
        @Nullable
        private Timestamp consensusTimestamp = null;
        @Nullable
        private TransactionID transactionID = null;
        @NonNull
        private String memo = "";
        private long transactionFee = 0L;
        private OneOf<BodyOneOfType> body = TransactionRecordProtoCodec.BODY_UNSET;
        @Nullable
        private TransferList transferList = null;
        @NonNull
        private List<TokenTransferList> tokenTransferLists = Collections.emptyList();
        @Nullable
        private ScheduleID scheduleRef = null;
        @NonNull
        private List<AssessedCustomFee> assessedCustomFees = Collections.emptyList();
        @NonNull
        private List<TokenAssociation> automaticTokenAssociations = Collections.emptyList();
        @Nullable
        private Timestamp parentConsensusTimestamp = null;
        @NonNull
        private Bytes alias = Bytes.EMPTY;
        @NonNull
        private Bytes ethereumHash = Bytes.EMPTY;
        @NonNull
        private List<AccountAmount> paidStakingRewards = Collections.emptyList();
        private OneOf<EntropyOneOfType> entropy = TransactionRecordProtoCodec.ENTROPY_UNSET;
        @NonNull
        private Bytes evmAddress = Bytes.EMPTY;
        @NonNull
        private List<PendingAirdropRecord> newPendingAirdrops = Collections.emptyList();
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(TransactionReceipt receipt, Bytes transactionHash, Timestamp consensusTimestamp, TransactionID transactionID, String memo, long transactionFee, OneOf<BodyOneOfType> body, TransferList transferList, List<TokenTransferList> tokenTransferLists, ScheduleID scheduleRef, List<AssessedCustomFee> assessedCustomFees, List<TokenAssociation> automaticTokenAssociations, Timestamp parentConsensusTimestamp, Bytes alias, Bytes ethereumHash, List<AccountAmount> paidStakingRewards, OneOf<EntropyOneOfType> entropy, Bytes evmAddress, List<PendingAirdropRecord> newPendingAirdrops) {
            this.$unknownFields = null;
            this.receipt = receipt;
            this.transactionHash = transactionHash != null ? transactionHash : Bytes.EMPTY;
            this.consensusTimestamp = consensusTimestamp;
            this.transactionID = transactionID;
            this.memo = memo != null ? memo : "";
            this.transactionFee = transactionFee;
            this.body = body;
            this.transferList = transferList;
            this.tokenTransferLists = tokenTransferLists == null ? Collections.emptyList() : tokenTransferLists;
            this.scheduleRef = scheduleRef;
            this.assessedCustomFees = assessedCustomFees == null ? Collections.emptyList() : assessedCustomFees;
            this.automaticTokenAssociations = automaticTokenAssociations == null ? Collections.emptyList() : automaticTokenAssociations;
            this.parentConsensusTimestamp = parentConsensusTimestamp;
            this.alias = alias != null ? alias : Bytes.EMPTY;
            this.ethereumHash = ethereumHash != null ? ethereumHash : Bytes.EMPTY;
            this.paidStakingRewards = paidStakingRewards == null ? Collections.emptyList() : paidStakingRewards;
            this.entropy = entropy;
            this.evmAddress = evmAddress != null ? evmAddress : Bytes.EMPTY;
            this.newPendingAirdrops = newPendingAirdrops == null ? Collections.emptyList() : newPendingAirdrops;
        }

        public Builder(TransactionReceipt receipt, Bytes transactionHash, Timestamp consensusTimestamp, TransactionID transactionID, String memo, long transactionFee, OneOf<BodyOneOfType> body, TransferList transferList, List<TokenTransferList> tokenTransferLists, ScheduleID scheduleRef, List<AssessedCustomFee> assessedCustomFees, List<TokenAssociation> automaticTokenAssociations, Timestamp parentConsensusTimestamp, Bytes alias, Bytes ethereumHash, List<AccountAmount> paidStakingRewards, OneOf<EntropyOneOfType> entropy, Bytes evmAddress, List<PendingAirdropRecord> newPendingAirdrops, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.receipt = receipt;
            this.transactionHash = transactionHash != null ? transactionHash : Bytes.EMPTY;
            this.consensusTimestamp = consensusTimestamp;
            this.transactionID = transactionID;
            this.memo = memo != null ? memo : "";
            this.transactionFee = transactionFee;
            this.body = body;
            this.transferList = transferList;
            this.tokenTransferLists = tokenTransferLists == null ? Collections.emptyList() : tokenTransferLists;
            this.scheduleRef = scheduleRef;
            this.assessedCustomFees = assessedCustomFees == null ? Collections.emptyList() : assessedCustomFees;
            this.automaticTokenAssociations = automaticTokenAssociations == null ? Collections.emptyList() : automaticTokenAssociations;
            this.parentConsensusTimestamp = parentConsensusTimestamp;
            this.alias = alias != null ? alias : Bytes.EMPTY;
            this.ethereumHash = ethereumHash != null ? ethereumHash : Bytes.EMPTY;
            this.paidStakingRewards = paidStakingRewards == null ? Collections.emptyList() : paidStakingRewards;
            this.entropy = entropy;
            this.evmAddress = evmAddress != null ? evmAddress : Bytes.EMPTY;
            this.newPendingAirdrops = newPendingAirdrops == null ? Collections.emptyList() : newPendingAirdrops;
        }

        public TransactionRecord build() {
            return new TransactionRecord(this.receipt, this.transactionHash, this.consensusTimestamp, this.transactionID, this.memo, this.transactionFee, this.body, this.transferList, this.tokenTransferLists, this.scheduleRef, this.assessedCustomFees, this.automaticTokenAssociations, this.parentConsensusTimestamp, this.alias, this.ethereumHash, this.paidStakingRewards, this.entropy, this.evmAddress, this.newPendingAirdrops);
        }

        public Builder receipt(@Nullable TransactionReceipt receipt) {
            this.receipt = receipt;
            return this;
        }

        public Builder receipt(TransactionReceipt.Builder builder) {
            this.receipt = builder.build();
            return this;
        }

        public Builder transactionHash(@NonNull Bytes transactionHash) {
            this.transactionHash = transactionHash != null ? transactionHash : Bytes.EMPTY;
            return this;
        }

        public Builder consensusTimestamp(@Nullable Timestamp consensusTimestamp) {
            this.consensusTimestamp = consensusTimestamp;
            return this;
        }

        public Builder consensusTimestamp(Timestamp.Builder builder) {
            this.consensusTimestamp = builder.build();
            return this;
        }

        public Builder transactionID(@Nullable TransactionID transactionID) {
            this.transactionID = transactionID;
            return this;
        }

        public Builder transactionID(TransactionID.Builder builder) {
            this.transactionID = builder.build();
            return this;
        }

        public Builder memo(@NonNull String memo) {
            this.memo = memo != null ? memo : "";
            return this;
        }

        public Builder transactionFee(long transactionFee) {
            this.transactionFee = transactionFee;
            return this;
        }

        public Builder contractCallResult(@Nullable ContractFunctionResult contractCallResult) {
            this.body = new OneOf((Enum)BodyOneOfType.CONTRACT_CALL_RESULT, (Object)contractCallResult);
            return this;
        }

        public Builder contractCallResult(ContractFunctionResult.Builder builder) {
            this.body = new OneOf((Enum)BodyOneOfType.CONTRACT_CALL_RESULT, (Object)builder.build());
            return this;
        }

        public Builder contractCreateResult(@Nullable ContractFunctionResult contractCreateResult) {
            this.body = new OneOf((Enum)BodyOneOfType.CONTRACT_CREATE_RESULT, (Object)contractCreateResult);
            return this;
        }

        public Builder contractCreateResult(ContractFunctionResult.Builder builder) {
            this.body = new OneOf((Enum)BodyOneOfType.CONTRACT_CREATE_RESULT, (Object)builder.build());
            return this;
        }

        public Builder transferList(@Nullable TransferList transferList) {
            this.transferList = transferList;
            return this;
        }

        public Builder transferList(TransferList.Builder builder) {
            this.transferList = builder.build();
            return this;
        }

        public Builder tokenTransferLists(@NonNull List<TokenTransferList> tokenTransferLists) {
            this.tokenTransferLists = tokenTransferLists != null ? tokenTransferLists : Collections.emptyList();
            return this;
        }

        public Builder tokenTransferLists(TokenTransferList ... values) {
            this.tokenTransferLists = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder scheduleRef(@Nullable ScheduleID scheduleRef) {
            this.scheduleRef = scheduleRef;
            return this;
        }

        public Builder scheduleRef(ScheduleID.Builder builder) {
            this.scheduleRef = builder.build();
            return this;
        }

        public Builder assessedCustomFees(@NonNull List<AssessedCustomFee> assessedCustomFees) {
            this.assessedCustomFees = assessedCustomFees != null ? assessedCustomFees : Collections.emptyList();
            return this;
        }

        public Builder assessedCustomFees(AssessedCustomFee ... values) {
            this.assessedCustomFees = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder automaticTokenAssociations(@NonNull List<TokenAssociation> automaticTokenAssociations) {
            this.automaticTokenAssociations = automaticTokenAssociations != null ? automaticTokenAssociations : Collections.emptyList();
            return this;
        }

        public Builder automaticTokenAssociations(TokenAssociation ... values) {
            this.automaticTokenAssociations = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder parentConsensusTimestamp(@Nullable Timestamp parentConsensusTimestamp) {
            this.parentConsensusTimestamp = parentConsensusTimestamp;
            return this;
        }

        public Builder parentConsensusTimestamp(Timestamp.Builder builder) {
            this.parentConsensusTimestamp = builder.build();
            return this;
        }

        public Builder alias(@NonNull Bytes alias) {
            this.alias = alias != null ? alias : Bytes.EMPTY;
            return this;
        }

        public Builder ethereumHash(@NonNull Bytes ethereumHash) {
            this.ethereumHash = ethereumHash != null ? ethereumHash : Bytes.EMPTY;
            return this;
        }

        public Builder paidStakingRewards(@NonNull List<AccountAmount> paidStakingRewards) {
            this.paidStakingRewards = paidStakingRewards != null ? paidStakingRewards : Collections.emptyList();
            return this;
        }

        public Builder paidStakingRewards(AccountAmount ... values) {
            this.paidStakingRewards = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder prngBytes(@NonNull Bytes prngBytes) {
            this.entropy = new OneOf((Enum)EntropyOneOfType.PRNG_BYTES, (Object)prngBytes);
            return this;
        }

        public Builder prngNumber(int prngNumber) {
            this.entropy = new OneOf((Enum)EntropyOneOfType.PRNG_NUMBER, (Object)prngNumber);
            return this;
        }

        public Builder evmAddress(@NonNull Bytes evmAddress) {
            this.evmAddress = evmAddress != null ? evmAddress : Bytes.EMPTY;
            return this;
        }

        public Builder newPendingAirdrops(@NonNull List<PendingAirdropRecord> newPendingAirdrops) {
            this.newPendingAirdrops = newPendingAirdrops != null ? newPendingAirdrops : Collections.emptyList();
            return this;
        }

        public Builder newPendingAirdrops(PendingAirdropRecord ... values) {
            this.newPendingAirdrops = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }
    }
}

