/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.generator;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.Consensus;
import com.swirlds.platform.ConsensusImpl;
import com.swirlds.platform.consensus.ConsensusConfig;
import com.swirlds.platform.consensus.RoundCalculationUtils;
import com.swirlds.platform.event.linking.SimpleLinker;
import com.swirlds.platform.event.orphan.DefaultOrphanBuffer;
import com.swirlds.platform.event.orphan.OrphanBuffer;
import com.swirlds.platform.gossip.IntakeEventCounter;
import com.swirlds.platform.gui.GuiEventStorage;
import com.swirlds.platform.gui.hashgraph.HashgraphGuiSource;
import com.swirlds.platform.gui.hashgraph.internal.StandardGuiSource;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.metrics.ConsensusMetrics;
import com.swirlds.platform.metrics.NoOpConsensusMetrics;
import com.swirlds.platform.test.fixtures.addressbook.RandomRosterBuilder;
import com.swirlds.platform.test.fixtures.event.DynamicValue;
import com.swirlds.platform.test.fixtures.event.DynamicValueGenerator;
import com.swirlds.platform.test.fixtures.event.EventUtils;
import com.swirlds.platform.test.fixtures.event.RandomEventUtils;
import com.swirlds.platform.test.fixtures.event.generator.AbstractGraphGenerator;
import com.swirlds.platform.test.fixtures.event.source.EventSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.crypto.DefaultEventHasher;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.ConsensusRound;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;
import org.mockito.Mockito;

public class StandardGraphGenerator
extends AbstractGraphGenerator {
    private final List<EventSource> sources;
    private DynamicValueGenerator<List<List<Double>>> affinityMatrix;
    private Roster roster;
    private double eventPeriodMean = 1.0E-4;
    private double eventPeriodStandardDeviation = 1.0E-5;
    private double simultaneousEventFraction = 0.01;
    private Instant previousTimestamp;
    private NodeId previousCreatorId;
    private ConsensusImpl consensus;
    private OrphanBuffer orphanBuffer;
    private ConsensusSnapshot consensusSnapshot;
    private final PlatformContext platformContext;
    private SimpleLinker linker;

    public StandardGraphGenerator(@NonNull PlatformContext platformContext, long seed, EventSource ... eventSources) {
        this(platformContext, seed, new ArrayList<EventSource>(Arrays.asList(eventSources)));
    }

    public StandardGraphGenerator(@NonNull PlatformContext platformContext, long seed, @NonNull List<EventSource> eventSources) {
        super(seed);
        this.platformContext = Objects.requireNonNull(platformContext);
        this.sources = Objects.requireNonNull(eventSources);
        if (eventSources.isEmpty()) {
            throw new IllegalArgumentException("At least one event source is required");
        }
        int eventSourceCount = eventSources.size();
        this.roster = RandomRosterBuilder.create(this.getRandom()).withSize(eventSourceCount).build();
        this.setAddressBookInitializeEventSources(eventSources, this.roster);
        this.buildDefaultOtherParentAffinityMatrix();
        this.initializeInternalConsensus();
    }

    public StandardGraphGenerator(@NonNull PlatformContext platformContext, long seed, @NonNull List<EventSource> eventSources, @NonNull Roster roster) {
        super(seed);
        this.platformContext = Objects.requireNonNull(platformContext);
        this.sources = Objects.requireNonNull(eventSources);
        if (eventSources.isEmpty()) {
            throw new IllegalArgumentException("At least one event source is required");
        }
        this.roster = roster;
        this.setAddressBookInitializeEventSources(eventSources, roster);
        this.buildDefaultOtherParentAffinityMatrix();
        this.initializeInternalConsensus();
    }

    private StandardGraphGenerator(StandardGraphGenerator that) {
        this(that, that.getInitialSeed());
    }

    private StandardGraphGenerator(StandardGraphGenerator that, long seed) {
        super(seed);
        this.affinityMatrix = that.affinityMatrix.cleanCopy();
        this.sources = new ArrayList<EventSource>(that.sources.size());
        for (EventSource sourceToCopy : that.sources) {
            EventSource copy = sourceToCopy.copy();
            this.sources.add(copy);
        }
        this.roster = that.roster;
        this.eventPeriodMean = that.eventPeriodMean;
        this.eventPeriodStandardDeviation = that.eventPeriodStandardDeviation;
        this.simultaneousEventFraction = that.simultaneousEventFraction;
        this.platformContext = that.platformContext;
        this.initializeInternalConsensus();
    }

    private void initializeInternalConsensus() {
        this.consensus = new ConsensusImpl(this.platformContext, (ConsensusMetrics)new NoOpConsensusMetrics(), this.roster);
        this.linker = new SimpleLinker();
        this.orphanBuffer = new DefaultOrphanBuffer(this.platformContext.getConfiguration(), this.platformContext.getMetrics(), (IntakeEventCounter)Mockito.mock(IntakeEventCounter.class));
    }

    private void setAddressBookInitializeEventSources(@NonNull List<EventSource> eventSources, @NonNull Roster roster) {
        int eventSourceCount = eventSources.size();
        for (int index = 0; index < eventSourceCount; ++index) {
            EventSource source = eventSources.get(index);
            NodeId nodeId = NodeId.of((long)((RosterEntry)roster.rosterEntries().get(index)).nodeId());
            source.setNodeId(nodeId);
        }
    }

    @Override
    public void setOtherParentAffinity(List<List<Double>> affinityMatrix) {
        this.setOtherParentAffinity(EventUtils.staticDynamicValue(affinityMatrix));
    }

    @Override
    public void setOtherParentAffinity(DynamicValue<List<List<Double>>> affinityMatrix) {
        this.affinityMatrix = new DynamicValueGenerator<List<List<Double>>>(affinityMatrix);
    }

    private List<Double> getOtherParentAffinityVector(long eventIndex, int nodeId) {
        return this.affinityMatrix.get(this.getRandom(), eventIndex).get(nodeId);
    }

    private void buildDefaultOtherParentAffinityMatrix() {
        ArrayList matrix = new ArrayList(this.sources.size());
        for (int nodeIndex = 0; nodeIndex < this.sources.size(); ++nodeIndex) {
            long nodeId = ((RosterEntry)this.roster.rosterEntries().get(nodeIndex)).nodeId();
            ArrayList<Double> affinityVector = new ArrayList<Double>(this.sources.size());
            for (int otherNodeIndex = 0; otherNodeIndex < this.sources.size(); ++otherNodeIndex) {
                long otherNodeId = ((RosterEntry)this.roster.rosterEntries().get(otherNodeIndex)).nodeId();
                if (Objects.equals(nodeId, otherNodeId)) {
                    affinityVector.add(0.0);
                    continue;
                }
                affinityVector.add(1.0);
            }
            matrix.add(affinityVector);
        }
        this.affinityMatrix = new DynamicValueGenerator(EventUtils.staticDynamicValue(matrix));
    }

    public double getSimultaneousEventFraction() {
        return this.simultaneousEventFraction;
    }

    public void setSimultaneousEventFraction(double simultaneousEventFraction) {
        this.simultaneousEventFraction = simultaneousEventFraction;
    }

    @Override
    public StandardGraphGenerator cleanCopy() {
        return new StandardGraphGenerator(this);
    }

    @Override
    public int getNumberOfSources() {
        return this.sources.size();
    }

    @Override
    public EventSource getSource(@NonNull NodeId nodeID) {
        int nodeIndex = RosterUtils.getIndex((Roster)this.roster, (long)nodeID.id());
        return this.sources.get(nodeIndex);
    }

    @Override
    @NonNull
    public EventSource getSourceByIndex(int nodeIndex) {
        return this.sources.get(nodeIndex);
    }

    @Override
    @NonNull
    public Roster getRoster() {
        return this.roster;
    }

    private List<Double> getSourceWeights(long eventIndex) {
        ArrayList<Double> sourceWeights = new ArrayList<Double>(this.sources.size());
        for (EventSource source : this.sources) {
            sourceWeights.add(source.getNewEventWeight(this.getRandom(), eventIndex));
        }
        return sourceWeights;
    }

    @Override
    protected void resetInternalData() {
        for (EventSource source : this.sources) {
            source.reset();
        }
        this.previousTimestamp = null;
        this.previousCreatorId = null;
        this.initializeInternalConsensus();
    }

    private EventSource getNextEventSource(long eventIndex) {
        int nodeIndex = EventUtils.weightedChoice(this.getRandom(), this.getSourceWeights(eventIndex));
        return this.sources.get(nodeIndex);
    }

    private EventSource getNextOtherParentSource(long eventIndex, EventSource source) {
        List<Double> affinityVector = this.getOtherParentAffinityVector(eventIndex, RosterUtils.getIndex((Roster)this.roster, (long)source.getNodeId().id()));
        int nodeIndex = EventUtils.weightedChoice(this.getRandom(), affinityVector);
        return this.sources.get(nodeIndex);
    }

    private Instant getNextTimestamp(EventSource source, NodeId otherParentId) {
        Instant timestamp;
        boolean forbidRepeatTimestamp;
        if (this.previousTimestamp == null) {
            this.previousTimestamp = RandomEventUtils.DEFAULT_FIRST_EVENT_TIME_CREATED;
            this.previousCreatorId = source.getNodeId();
            return this.previousTimestamp;
        }
        EventImpl previousEvent = source.getLatestEvent(this.getRandom());
        Instant previousTimestampForSource = previousEvent == null ? Instant.ofEpochSecond(0L) : previousEvent.getTimeCreated();
        boolean shouldRepeatTimestamp = this.getRandom().nextDouble() < this.simultaneousEventFraction;
        boolean bl = forbidRepeatTimestamp = this.previousCreatorId != null && (this.previousCreatorId.equals((Object)source.getNodeId()) || this.previousCreatorId.equals((Object)otherParentId));
        if (!previousTimestampForSource.equals(this.previousTimestamp) && shouldRepeatTimestamp && !forbidRepeatTimestamp) {
            return this.previousTimestamp;
        }
        double delta = Math.max(1.0E-9, this.eventPeriodMean + this.eventPeriodStandardDeviation * this.getRandom().nextGaussian());
        long deltaSeconds = (int)delta;
        long deltaNanoseconds = (int)((delta - (double)deltaSeconds) * 1.0E9);
        this.previousTimestamp = timestamp = this.previousTimestamp.plusSeconds(deltaSeconds).plusNanos(deltaNanoseconds);
        this.previousCreatorId = source.getNodeId();
        return timestamp;
    }

    @Override
    public EventImpl buildNextEvent(long eventIndex) {
        EventSource source = this.getNextEventSource(eventIndex);
        EventSource otherParentSource = this.getNextOtherParentSource(eventIndex, source);
        long birthRound = this.consensus.getLastRoundDecided() + 1L;
        EventImpl next = source.generateEvent(this.getRandom(), eventIndex, otherParentSource, this.getNextTimestamp(source, otherParentSource.getNodeId()), birthRound);
        new DefaultEventHasher().hashEvent(next.getBaseEvent());
        this.updateConsensus(next);
        return next;
    }

    private void updateConsensus(@NonNull EventImpl e) {
        PlatformEvent copy = e.getBaseEvent().copyGossipedData();
        List events = this.orphanBuffer.handleEvent(copy);
        for (PlatformEvent event : events) {
            List consensusRounds;
            EventImpl linkedEvent = this.linker.linkEvent(event);
            if (linkedEvent == null || (consensusRounds = this.consensus.addEvent(linkedEvent)).isEmpty()) continue;
            this.consensusSnapshot = ((ConsensusRound)consensusRounds.getLast()).getSnapshot();
            this.linker.setNonAncientThreshold(((ConsensusRound)consensusRounds.getLast()).getEventWindow().ancientThreshold());
        }
    }

    @Override
    public void removeNode(@NonNull NodeId nodeId) {
        int nodeIndex = RosterUtils.getIndex((Roster)this.roster, (long)nodeId.id());
        this.sources.remove(nodeIndex);
        ArrayList newRosterEntries = new ArrayList(this.roster.rosterEntries());
        newRosterEntries.remove(nodeIndex);
        this.roster = new Roster(newRosterEntries);
        this.buildDefaultOtherParentAffinityMatrix();
        ArrayList<EventImpl> nonAncientEvents = new ArrayList<EventImpl>(this.linker.getNonAncientEvents());
        nonAncientEvents.sort(Comparator.comparingLong(e -> e.getBaseEvent().getNGen()));
        this.initializeInternalConsensus();
        this.consensus.loadSnapshot(this.consensusSnapshot);
        this.linker.setNonAncientThreshold(RoundCalculationUtils.getAncientThreshold((int)((ConsensusConfig)this.platformContext.getConfiguration().getConfigData(ConsensusConfig.class)).roundsNonAncient(), (ConsensusSnapshot)this.consensusSnapshot));
        for (EventImpl event : nonAncientEvents) {
            this.updateConsensus(event);
        }
    }

    public HashgraphGuiSource createGuiSource() {
        return new StandardGuiSource(this.getRoster(), new GuiEventStorage((Consensus)this.consensus, this.linker, this.platformContext.getConfiguration()));
    }
}

