/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.utility;

import com.swirlds.base.utility.Retry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;

public final class FileSystemUtils {
    private FileSystemUtils() {
    }

    public static boolean waitForPathPresence(@NonNull Path path) {
        return FileSystemUtils.waitForPathPresence(path, Retry.DEFAULT_WAIT_TIME);
    }

    public static boolean waitForPathPresence(@NonNull Path path, @NonNull Duration waitTime) {
        return FileSystemUtils.waitForPathPresence(path, waitTime, Retry.DEFAULT_RETRY_DELAY);
    }

    public static boolean waitForPathPresence(@NonNull Path path, @NonNull Duration waitTime, @NonNull Duration retryDelay) {
        Objects.requireNonNull(path, "path must not be null");
        try {
            return Retry.check(FileSystemUtils::checkForPathPresenceInternal, path, waitTime, retryDelay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private static boolean checkForPathPresenceInternal(@NonNull Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try {
                return Files.size(path) > 0L;
            }
            catch (IOException ignored) {
                return false;
            }
        }
        return true;
    }
}

