/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.protocol.rpc;

import com.google.common.collect.Maps;
import com.hedera.hapi.platform.message.GossipPing;
import com.swirlds.base.time.Time;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.network.NetworkMetrics;
import com.swirlds.platform.network.protocol.rpc.RpcPeerProtocol;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;

final class RpcPingHandler {
    private static final Logger logger = LogManager.getLogger(RpcPingHandler.class);
    private final Time time;
    private final ConcurrentMap<Long, GossipPing> sentPings = Maps.newConcurrentMap();
    private final NetworkMetrics networkMetrics;
    private final NodeId remotePeerId;
    private final RpcPeerProtocol rpcPeerProtocol;
    private long pingId = 1L;
    private long lastPingTime;

    RpcPingHandler(@NonNull Time time, NetworkMetrics networkMetrics, NodeId remotePeerId, RpcPeerProtocol rpcPeerProtocol) {
        this.time = Objects.requireNonNull(time);
        this.networkMetrics = Objects.requireNonNull(networkMetrics);
        this.remotePeerId = Objects.requireNonNull(remotePeerId);
        this.rpcPeerProtocol = Objects.requireNonNull(rpcPeerProtocol);
    }

    void handleIncomingPing(GossipPing ping) {
        GossipPing reply = new GossipPing(this.time.currentTimeMillis(), ping.correlationId());
        this.rpcPeerProtocol.sendPingReply(reply);
    }

    GossipPing possiblyInitiatePing() {
        long timestamp = this.time.currentTimeMillis();
        if (timestamp - this.lastPingTime < 1000L) {
            return null;
        }
        this.lastPingTime = timestamp;
        GossipPing ping = new GossipPing(timestamp, this.pingId++);
        this.sentPings.put(ping.correlationId(), ping);
        return ping;
    }

    void handleIncomingPingReply(GossipPing pingReply) {
        GossipPing original = (GossipPing)this.sentPings.remove(pingReply.correlationId());
        if (original == null) {
            logger.error(LogMarker.NETWORK.getMarker(), "Received unexpected gossip ping reply from peer {} for correlation id {}", (Object)this.remotePeerId, (Object)pingReply.correlationId());
        } else {
            logger.debug(LogMarker.NETWORK.getMarker(), "Ping {}", (Object)(this.time.currentTimeMillis() - original.timestamp()));
            this.networkMetrics.recordPingTime(this.remotePeerId, (this.time.currentTimeMillis() - original.timestamp()) * 1000000L);
        }
    }
}

