/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.hash.VirtualHashListener;
import com.swirlds.virtualmap.internal.reconnect.ReconnectHashLeafFlusher;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.base.crypto.Hash;

public class ReconnectHashListener
implements VirtualHashListener {
    private final ReconnectHashLeafFlusher flusher;

    public ReconnectHashListener(@NonNull ReconnectHashLeafFlusher flusher) {
        this.flusher = Objects.requireNonNull(flusher);
    }

    @Override
    public void onHashingStarted(long firstLeafPath, long lastLeafPath) {
        this.flusher.start(firstLeafPath, lastLeafPath);
    }

    @Override
    public void onNodeHashed(long path, Hash hash) {
        this.flusher.updateHash(path, hash);
    }

    public void onLeafHashed(VirtualLeafBytes leaf) {
        this.flusher.updateLeaf(leaf);
    }

    @Override
    public void onHashingCompleted() {
        this.flusher.finish();
    }
}

