/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.lang.reflect.Array;
import java.util.AbstractList;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Preconditions;

final class PrimitiveArrayList
extends AbstractList<Object> {
    private final Object array;

    PrimitiveArrayList(Object array) {
        Preconditions.checkArgument(Arrays.isObjectArray(array) || Arrays.isArrayTypePrimitive(array), "input must be an array", new Object[0]);
        this.array = array;
    }

    @Override
    public Object get(int index) {
        return Array.get(this.array, index);
    }

    @Override
    public int size() {
        return Array.getLength(this.array);
    }
}

