/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.common.merkle.synchronization.task.ReconnectNodeCount;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.reconnect.NodeTraversalOrder;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TopToBottomTraversalOrder
implements NodeTraversalOrder {
    private ReconnectNodeCount nodeCount;
    private long reconnectFirstLeafPath;
    private long reconnectLastLeafPath;
    private long lastPath = 0L;
    private final Set<Long> cleanNodes = ConcurrentHashMap.newKeySet();

    @Override
    public void start(long firstLeafPath, long lastLeafPath, ReconnectNodeCount nodeCount) {
        this.reconnectFirstLeafPath = firstLeafPath;
        this.reconnectLastLeafPath = lastLeafPath;
        this.nodeCount = nodeCount;
    }

    @Override
    public void nodeReceived(long path, boolean isClean) {
        boolean isLeaf;
        boolean bl = isLeaf = path >= this.reconnectFirstLeafPath;
        if (isClean && !isLeaf) {
            this.cleanNodes.add(path);
        }
        if (isLeaf) {
            this.nodeCount.incrementLeafCount();
            if (isClean) {
                this.nodeCount.incrementRedundantLeafCount();
            }
        } else {
            this.nodeCount.incrementInternalCount();
            if (isClean) {
                this.nodeCount.incrementRedundantInternalCount();
            }
        }
    }

    @Override
    public long getNextPathToSend() {
        assert (this.lastPath != -1L);
        long path = this.lastPath + 1L;
        long result = this.skipCleanPaths(path);
        while (result != -1L && result != path) {
            path = result;
            result = this.skipCleanPaths(path);
        }
        this.lastPath = result;
        return this.lastPath;
    }

    private long skipCleanPaths(long path) {
        assert (path > 0L);
        if (path > this.reconnectLastLeafPath) {
            return -1L;
        }
        long parent = Path.getParentPath(path);
        long cleanParent = -1L;
        int parentRanksAbove = 1;
        int cleanParentRanksAbove = 1;
        while (parent != 0L) {
            if (this.cleanNodes.contains(parent)) {
                cleanParent = parent;
                cleanParentRanksAbove = parentRanksAbove;
            }
            ++parentRanksAbove;
            parent = Path.getParentPath(parent);
        }
        long result = cleanParent == -1L ? path : Path.getRightGrandChildPath(cleanParent, cleanParentRanksAbove) + 1L;
        assert (result >= path);
        return result <= this.reconnectLastLeafPath ? result : -1L;
    }
}

