/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.communication.handshake;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.NetworkProtocolException;
import com.swirlds.platform.network.communication.handshake.HandshakeException;
import com.swirlds.platform.network.protocol.ProtocolRunnable;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.SelfSerializable;

public class HashCompareHandshake
implements ProtocolRunnable {
    private static final Logger logger = LogManager.getLogger(HashCompareHandshake.class);
    private final Hash hash;
    private final boolean throwOnMismatch;

    public HashCompareHandshake(@Nullable Hash hash, boolean throwOnMismatch) {
        this.hash = hash;
        this.throwOnMismatch = throwOnMismatch;
    }

    @Override
    public void runProtocol(@NonNull Connection connection) throws NetworkProtocolException, IOException, InterruptedException {
        connection.getDos().writeSerializable((SelfSerializable)this.hash, false);
        connection.getDos().flush();
        SelfSerializable readSerializable = connection.getDis().readSerializable(false, Hash::new);
        if (Objects.equals(this.hash, readSerializable)) {
            return;
        }
        String message = String.format("Incompatible hash. Self hash is '%s', peer hash is '%s'", this.hash, readSerializable);
        if (this.throwOnMismatch) {
            throw new HandshakeException(message);
        }
        logger.error(LogMarker.EXCEPTION.getMarker(), message);
    }
}

