/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.io.SerializableWithKnownLength;
import org.hiero.base.io.exceptions.BadIOException;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.base.utility.CommonUtils;

public class Hash
implements Comparable<Hash>,
SerializableWithKnownLength,
Serializable {
    public static final long CLASS_ID = -854880720348154850L;
    public static final int CLASS_VERSION = 1;
    private Bytes bytes;
    private DigestType digestType;

    public Hash() {
        this(DigestType.SHA_384);
    }

    public Hash(@NonNull DigestType digestType) {
        this(Bytes.wrap((byte[])new byte[digestType.digestLength()]), digestType);
    }

    public Hash(@NonNull byte[] value) {
        this(Bytes.wrap((byte[])value), DigestType.SHA_384);
    }

    public Hash(@NonNull Bytes value) {
        this(value, DigestType.SHA_384);
    }

    public Hash(@NonNull byte[] value, @NonNull DigestType digestType) {
        this(Bytes.wrap((byte[])value), digestType);
    }

    public Hash(@NonNull Bytes value, @NonNull DigestType digestType) {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(digestType, "digestType");
        if ((int)value.length() != digestType.digestLength()) {
            throw new IllegalArgumentException("value: " + value.length());
        }
        this.digestType = digestType;
        this.bytes = value;
    }

    public Hash(@NonNull Hash other) {
        if (other == null) {
            throw new IllegalArgumentException("other");
        }
        this.digestType = other.digestType;
        this.bytes = other.bytes;
    }

    @NonNull
    public byte[] copyToByteArray() {
        return this.bytes.toByteArray();
    }

    @NonNull
    public Bytes getBytes() {
        return this.bytes;
    }

    @NonNull
    public Hash copy() {
        return new Hash(this);
    }

    public long getClassId() {
        return -854880720348154850L;
    }

    public int getVersion() {
        return 1;
    }

    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        Objects.requireNonNull(this.digestType, "digestType");
        Objects.requireNonNull(this.bytes, "bytes");
        out.writeInt(this.digestType.id());
        out.writeInt((int)this.bytes.length());
        this.bytes.writeTo((OutputStream)out);
    }

    public int getSerializedLength() {
        return 8 + (int)this.bytes.length();
    }

    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        DigestType digestType = DigestType.valueOf(in.readInt());
        if (digestType == null) {
            throw new BadIOException("Invalid DigestType identifier read from the stream");
        }
        this.digestType = digestType;
        byte[] value = in.readByteArray(digestType.digestLength());
        if (value == null) {
            throw new BadIOException("Invalid hash value read from the stream");
        }
        this.bytes = Bytes.wrap((byte[])value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Hash)) {
            return false;
        }
        Hash that = (Hash)obj;
        return this.digestType.id() == that.digestType.id() && Objects.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return this.bytes.getInt(0L);
    }

    @Override
    public int compareTo(@NonNull Hash that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            throw new NullPointerException("that");
        }
        int ret = Integer.compare(this.digestType.id(), that.digestType.id());
        if (ret != 0) {
            return ret;
        }
        return Bytes.SORT_BY_SIGNED_VALUE.compare(this.bytes, that.bytes);
    }

    @NonNull
    public String toString() {
        return this.bytes == null ? "null" : this.bytes.toHex();
    }

    @NonNull
    public String toHex() {
        return this.toString();
    }

    @NonNull
    public String toHex(int length) {
        return this.bytes == null ? "null" : CommonUtils.hex((Bytes)this.bytes, (int)length);
    }

    @NonNull
    public DigestType getDigestType() {
        return this.digestType;
    }
}

