/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.legacy.payload;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.swirlds.logging.legacy.payload.LogPayload;
import com.swirlds.logging.legacy.payload.PayloadParsingException;

public abstract class AbstractLogPayload
implements LogPayload {
    private String message;
    private static final ObjectMapper mapper = new ObjectMapper();

    public AbstractLogPayload() {
    }

    public AbstractLogPayload(String message) {
        this.setMessage(message);
    }

    @Override
    @JsonIgnore
    public final String getMessage() {
        return this.message;
    }

    @Override
    @JsonIgnore
    public final void setMessage(String message) {
        if (message.indexOf(123) != -1) {
            throw new IllegalArgumentException("The character '{' is not permitted in the message field.\nIllegal message: \"%s\"\n".formatted(message));
        }
        this.message = message;
    }

    private String serializeData() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    @JsonIgnore
    public final String toString() {
        return this.message + " " + this.serializeData() + " " + AbstractLogPayload.getMessageIdentifier(this.getClass());
    }

    @JsonIgnore
    public static String getMessageIdentifier(Class<? extends AbstractLogPayload> c) {
        return "[" + c.getName() + "]";
    }

    public static String extractPayloadType(String data) {
        try {
            int startIndex = data.lastIndexOf(91) + 1;
            int endIndex = data.lastIndexOf(93);
            return data.substring(startIndex, endIndex);
        }
        catch (IndexOutOfBoundsException ignored) {
            return "";
        }
    }

    private static JsonNode extractJsonData(String data) {
        try {
            int startIndex = data.indexOf(123);
            int endIndex = data.lastIndexOf(125) + 1;
            String jsonString = data.substring(startIndex, endIndex);
            return mapper.readTree(jsonString);
        }
        catch (JsonProcessingException | IndexOutOfBoundsException e) {
            throw new PayloadParsingException(e);
        }
    }

    private static String extractMessage(String data) {
        try {
            int endIndex = data.indexOf(123) - 1;
            return data.substring(0, endIndex);
        }
        catch (IndexOutOfBoundsException ignored) {
            return "";
        }
    }

    public static <T extends LogPayload> T parsePayload(Class<T> type, String data) {
        LogPayload payload;
        try {
            payload = (LogPayload)mapper.treeToValue((TreeNode)AbstractLogPayload.extractJsonData(data), type);
        }
        catch (JsonProcessingException e) {
            throw new PayloadParsingException("Unable to map json data onto object", e);
        }
        payload.setMessage(AbstractLogPayload.extractMessage(data));
        return (T)payload;
    }

    static {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.registerModule((Module)new JavaTimeModule());
    }
}

