/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.state;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.JudgeId;
import com.hedera.hapi.platform.state.MinimumJudgeInfo;
import com.swirlds.base.time.Time;
import com.swirlds.base.utility.Pair;
import com.swirlds.common.Reservable;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.metrics.noop.NoOpMetrics;
import com.swirlds.common.test.fixtures.WeightGenerators;
import com.swirlds.common.test.fixtures.merkle.TestMerkleCryptoFactory;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.extensions.test.fixtures.TestConfigBuilder;
import com.swirlds.merkledb.test.fixtures.MerkleDbTestUtils;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.crypto.SignatureVerifier;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.test.fixtures.addressbook.RandomRosterBuilder;
import com.swirlds.platform.test.fixtures.state.TestPlatformStateFacade;
import com.swirlds.platform.test.fixtures.state.TestVirtualMapState;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import com.swirlds.platform.test.fixtures.state.manager.SignatureVerificationTestUtils;
import com.swirlds.state.State;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.Field;
import java.security.PublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Signature;
import org.hiero.base.crypto.test.fixtures.CryptoRandomUtils;
import org.hiero.base.utility.CommonUtils;
import org.hiero.base.utility.test.fixtures.RandomUtils;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;
import org.mockito.Mockito;

public class RandomSignedStateGenerator {
    private static final Logger logger = LogManager.getLogger(RandomSignedStateGenerator.class);
    private static final ThreadLocal<List<SignedState>> builtSignedStates = ThreadLocal.withInitial(ArrayList::new);
    final Random random;
    private MerkleNodeState state;
    private Long round;
    private Hash legacyRunningEventHash;
    private Roster roster;
    private Instant consensusTimestamp;
    private Boolean freezeState = false;
    private SemanticVersion softwareVersion;
    private List<NodeId> signingNodeIds;
    private Map<NodeId, Signature> signatures;
    private Function<Hash, Map<NodeId, Signature>> signatureSupplier;
    private Integer roundsNonAncient = null;
    private ConsensusSnapshot consensusSnapshot;
    private SignatureVerifier signatureVerifier;
    private boolean deleteOnBackgroundThread;
    private boolean pcesRound;

    public RandomSignedStateGenerator() {
        this.random = RandomUtils.getRandomPrintSeed();
    }

    public RandomSignedStateGenerator(long seed) {
        this.random = new Random(seed);
    }

    public RandomSignedStateGenerator(Random random) {
        this.random = random;
    }

    public SignedState build() {
        return (SignedState)this.buildWithFacade().left();
    }

    public Pair<SignedState, TestPlatformStateFacade> buildWithFacade() {
        Map<NodeId, Signature> signaturesInstance;
        MerkleNodeState stateInstance;
        Roster rosterInstance = this.roster == null ? RandomRosterBuilder.create(this.random).withWeightGenerator(WeightGenerators.BALANCED_1000_PER_NODE).build() : this.roster;
        SemanticVersion softwareVersionInstance = this.softwareVersion == null ? SemanticVersion.newBuilder().major(this.random.nextInt(1, 100)).build() : this.softwareVersion;
        long roundInstance = this.round == null ? Math.abs(this.random.nextLong()) : this.round;
        TestPlatformStateFacade platformStateFacade = new TestPlatformStateFacade();
        if (this.state == null) {
            String virtualMapLabel = "vm-" + RandomSignedStateGenerator.class.getSimpleName() + "-" + String.valueOf(UUID.randomUUID());
            stateInstance = TestVirtualMapState.createInstanceWithVirtualMapLabel(virtualMapLabel);
            stateInstance.init(Time.getCurrent(), (Metrics)new NoOpMetrics(), TestMerkleCryptoFactory.getInstance(), () -> platformStateFacade.roundOf((State)stateInstance));
        } else {
            stateInstance = this.state;
        }
        Hash legacyRunningEventHashInstance = this.legacyRunningEventHash == null ? CryptoRandomUtils.randomHash((Random)this.random) : this.legacyRunningEventHash;
        Instant consensusTimestampInstance = this.consensusTimestamp == null ? RandomUtils.randomInstant((Random)this.random) : this.consensusTimestamp;
        boolean freezeStateInstance = this.freezeState == null ? this.random.nextBoolean() : this.freezeState.booleanValue();
        int roundsNonAncientInstance = this.roundsNonAncient == null ? 26 : this.roundsNonAncient;
        List<JudgeId> judges = Stream.generate(() -> new JudgeId(0L, CryptoRandomUtils.randomHashBytes((Random)this.random))).limit(10L).toList();
        ConsensusSnapshot consensusSnapshotInstance = this.consensusSnapshot == null ? ConsensusSnapshot.newBuilder().round(roundInstance).judgeIds(judges).minimumJudgeInfoList(IntStream.range(0, roundsNonAncientInstance).mapToObj(i -> new MinimumJudgeInfo(roundInstance - (long)i, 0L)).toList()).nextConsensusNumber(roundInstance).consensusTimestamp(CommonUtils.toPbjTimestamp((Instant)consensusTimestampInstance)).build() : this.consensusSnapshot;
        TestingAppStateInitializer.DEFAULT.initPlatformState(stateInstance);
        platformStateFacade.bulkUpdateOf((State)stateInstance, v -> {
            v.setSnapshot(consensusSnapshotInstance);
            v.setLegacyRunningEventHash(legacyRunningEventHashInstance);
            v.setCreationSoftwareVersion(softwareVersionInstance);
            v.setRoundsNonAncient(roundsNonAncientInstance);
            v.setConsensusTimestamp(consensusTimestampInstance);
        });
        TestingAppStateInitializer.DEFAULT.initRosterState(stateInstance);
        RosterUtils.setActiveRoster((State)stateInstance, (Roster)rosterInstance, (long)roundInstance);
        if (this.signatureVerifier == null) {
            this.signatureVerifier = SignatureVerificationTestUtils::verifySignature;
        }
        Configuration configuration = new TestConfigBuilder().withValue("state.stateHistoryEnabled", true).withConfigDataType(StateConfig.class).getOrCreateConfig();
        SignedState signedState = new SignedState(configuration, this.signatureVerifier, stateInstance, "RandomSignedStateGenerator.build()", freezeStateInstance, this.deleteOnBackgroundThread, this.pcesRound, (PlatformStateFacade)platformStateFacade);
        signedState.init(PlatformContext.create((Configuration)configuration));
        if (this.signatureSupplier != null) {
            signaturesInstance = this.signatureSupplier.apply(stateInstance.getRoot().getHash());
        } else if (this.signatures == null) {
            List<NodeId> signingNodeIdsInstance;
            if (this.signingNodeIds == null) {
                signingNodeIdsInstance = new LinkedList<NodeId>();
                if (!rosterInstance.rosterEntries().isEmpty()) {
                    for (int i2 = 0; i2 < rosterInstance.rosterEntries().size() / 3 + 1; ++i2) {
                        RosterEntry node = (RosterEntry)rosterInstance.rosterEntries().get(i2);
                        signingNodeIdsInstance.add(NodeId.of((long)node.nodeId()));
                    }
                }
            } else {
                signingNodeIdsInstance = this.signingNodeIds;
            }
            signaturesInstance = new HashMap<NodeId, Signature>();
            for (NodeId nodeID : signingNodeIdsInstance) {
                signaturesInstance.put(nodeID, CryptoRandomUtils.randomSignature((Random)this.random));
            }
        } else {
            signaturesInstance = this.signatures;
        }
        for (NodeId nodeId : signaturesInstance.keySet()) {
            signedState.addSignature(nodeId, signaturesInstance.get(nodeId));
        }
        builtSignedStates.get().add(signedState);
        return Pair.of((Object)signedState, (Object)((Object)((TestPlatformStateFacade)((Object)Mockito.spy((Object)((Object)platformStateFacade))))));
    }

    public List<SignedState> build(int count) {
        ArrayList<SignedState> states = new ArrayList<SignedState>(count);
        for (int i = 0; i < count; ++i) {
            states.add(this.build());
        }
        return states;
    }

    @NonNull
    public RandomSignedStateGenerator setDeleteOnBackgroundThread(boolean deleteOnBackgroundThread) {
        this.deleteOnBackgroundThread = deleteOnBackgroundThread;
        return this;
    }

    public RandomSignedStateGenerator setState(MerkleNodeState state) {
        this.state = state;
        return this;
    }

    public RandomSignedStateGenerator setRound(long round) {
        this.round = round;
        return this;
    }

    public RandomSignedStateGenerator setLegacyRunningEventHash(Hash legacyRunningEventHash) {
        this.legacyRunningEventHash = legacyRunningEventHash;
        return this;
    }

    public RandomSignedStateGenerator setRoster(Roster roster) {
        this.roster = roster;
        return this;
    }

    public RandomSignedStateGenerator setConsensusTimestamp(Instant consensusTimestamp) {
        this.consensusTimestamp = consensusTimestamp;
        return this;
    }

    public RandomSignedStateGenerator setFreezeState(boolean freezeState) {
        this.freezeState = freezeState;
        return this;
    }

    public RandomSignedStateGenerator setSoftwareVersion(SemanticVersion softwareVersion) {
        this.softwareVersion = softwareVersion;
        return this;
    }

    @NonNull
    public RandomSignedStateGenerator setSigningNodeIds(@NonNull List<NodeId> signingNodeIds) {
        Objects.requireNonNull(signingNodeIds, "signingNodeIds must not be null");
        this.signingNodeIds = signingNodeIds;
        return this;
    }

    @NonNull
    public RandomSignedStateGenerator setSignatures(@NonNull Map<NodeId, Signature> signatures) {
        Objects.requireNonNull(signatures, "signatures must not be null");
        this.signatures = signatures;
        return this;
    }

    @NonNull
    public RandomSignedStateGenerator useSignatureSupplierFromRoster() {
        Objects.requireNonNull(this.roster, "roster must not be null");
        this.signatureSupplier = RandomSignedStateGenerator.createSignatureSupplier(this.roster);
        return this;
    }

    public RandomSignedStateGenerator setRoundsNonAncient(int roundsNonAncient) {
        this.roundsNonAncient = roundsNonAncient;
        return this;
    }

    @NonNull
    public RandomSignedStateGenerator setConsensusSnapshot(@NonNull ConsensusSnapshot consensusSnapshot) {
        this.consensusSnapshot = consensusSnapshot;
        return this;
    }

    @NonNull
    public RandomSignedStateGenerator setSignatureVerifier(@NonNull SignatureVerifier signatureVerifier) {
        this.signatureVerifier = signatureVerifier;
        return this;
    }

    @NonNull
    public RandomSignedStateGenerator setPcesRound(boolean pcesRound) {
        this.pcesRound = pcesRound;
        return this;
    }

    public static void releaseReservable(@NonNull Reservable reservable) {
        while (reservable.getReservationCount() >= 0) {
            reservable.release();
        }
    }

    public static void releaseAllBuiltSignedStates() {
        builtSignedStates.get().forEach(signedState -> {
            try {
                RandomSignedStateGenerator.releaseReservable((Reservable)signedState.getState().getRoot());
                signedState.getState().getRoot().treeIterator().forEachRemaining(node -> {
                    if (node instanceof VirtualMap) {
                        while (node.getReservationCount() >= 0) {
                            node.release();
                        }
                    }
                });
            }
            catch (Exception e) {
                logger.error("Exception while releasing state", (Throwable)e);
            }
        });
        MerkleDbTestUtils.assertAllDatabasesClosed();
        builtSignedStates.get().clear();
    }

    public static void forgetAllBuiltSignedStatesWithoutReleasing() {
        builtSignedStates.get().clear();
    }

    public static void changeStateHashRandomly(@NonNull SignedState state) {
        try {
            Field hashField = VirtualMap.class.getDeclaredField("hash");
            hashField.setAccessible(true);
            AtomicReference hashRef = (AtomicReference)hashField.get(state.getState().getRoot());
            Hash newHash = CryptoRandomUtils.randomHash();
            hashRef.set(newHash);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Function<Hash, Map<NodeId, Signature>> createSignatureSupplier(Roster roster) {
        return hash -> {
            HashMap<NodeId, Signature> signatures = new HashMap<NodeId, Signature>();
            for (RosterEntry node : roster.rosterEntries()) {
                PublicKey publicKey = RosterUtils.fetchGossipCaCertificate((RosterEntry)node).getPublicKey();
                signatures.put(NodeId.of((long)node.nodeId()), SignatureVerificationTestUtils.buildFakeSignature(publicKey, hash));
            }
            return signatures;
        };
    }
}

