/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.platform;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.filesystem.FileSystemManager;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.io.utility.NoOpRecycleBin;
import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.crypto.MerkleCryptographyFactory;
import com.swirlds.common.metrics.noop.NoOpMetrics;
import com.swirlds.common.test.fixtures.TestFileSystemManager;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.hiero.base.concurrent.ExecutorFactory;
import org.junit.jupiter.api.Assertions;

public final class TestPlatformContextBuilder {
    private static final Metrics defaultMetrics = new NoOpMetrics();
    private static final Configuration defaultConfig = ConfigurationBuilder.create().autoDiscoverExtensions().build();
    private static final MerkleCryptography defaultMerkleCryptography = MerkleCryptographyFactory.create((Configuration)defaultConfig);
    private Configuration configuration;
    private Metrics metrics;
    private Time time = Time.getCurrent();
    private FileSystemManager fileSystemManager;
    private RecycleBin recycleBin;
    private MerkleCryptography merkleCryptography;

    private TestPlatformContextBuilder() {
    }

    @NonNull
    public static TestPlatformContextBuilder create() {
        return new TestPlatformContextBuilder();
    }

    @NonNull
    public TestPlatformContextBuilder withConfiguration(@Nullable Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    @NonNull
    public TestPlatformContextBuilder withMetrics(@Nullable Metrics metrics) {
        this.metrics = metrics;
        return this;
    }

    @NonNull
    public TestPlatformContextBuilder withTime(@NonNull Time time) {
        this.time = Objects.requireNonNull(time);
        return this;
    }

    @NonNull
    public TestPlatformContextBuilder withRecycleBin(@Nullable RecycleBin recycleBin) {
        this.recycleBin = recycleBin;
        return this;
    }

    @NonNull
    public TestPlatformContextBuilder withFileSystemManager(@NonNull FileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
        return this;
    }

    @NonNull
    public TestPlatformContextBuilder withTestFileSystemManagerUnder(@NonNull Path rootPath) {
        this.fileSystemManager = new TestFileSystemManager(rootPath);
        return this;
    }

    @NonNull
    public TestPlatformContextBuilder withMerkleCryptography(@NonNull MerkleCryptography merkleCryptography) {
        this.merkleCryptography = merkleCryptography;
        return this;
    }

    public PlatformContext build() {
        if (this.configuration == null) {
            this.configuration = defaultConfig;
        }
        if (this.metrics == null) {
            this.metrics = defaultMetrics;
        }
        if (this.recycleBin == null) {
            this.recycleBin = new NoOpRecycleBin();
        }
        if (this.fileSystemManager == null) {
            this.fileSystemManager = TestPlatformContextBuilder.getTestFileSystemManager();
        }
        if (this.merkleCryptography == null) {
            this.merkleCryptography = defaultMerkleCryptography;
        }
        final ExecutorFactory executorFactory = ExecutorFactory.create((String)"test", (Thread.UncaughtExceptionHandler)new Thread.UncaughtExceptionHandler(this){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Assertions.fail((String)("Uncaught exception in thread " + t.getName()), (Throwable)e);
            }
        });
        return new PlatformContext(){

            @NonNull
            public Configuration getConfiguration() {
                return TestPlatformContextBuilder.this.configuration;
            }

            @NonNull
            public Metrics getMetrics() {
                return TestPlatformContextBuilder.this.metrics;
            }

            @NonNull
            public Time getTime() {
                return TestPlatformContextBuilder.this.time;
            }

            @NonNull
            public FileSystemManager getFileSystemManager() {
                return TestPlatformContextBuilder.this.fileSystemManager;
            }

            @NonNull
            public ExecutorFactory getExecutorFactory() {
                return executorFactory;
            }

            @NonNull
            public RecycleBin getRecycleBin() {
                return TestPlatformContextBuilder.this.recycleBin;
            }

            @NonNull
            public MerkleCryptography getMerkleCryptography() {
                return TestPlatformContextBuilder.this.merkleCryptography;
            }
        };
    }

    private static TestFileSystemManager getTestFileSystemManager() {
        Path defaultRootLocation = (Path)FileUtils.rethrowIO(() -> Files.createTempDirectory("testRootDir", new FileAttribute[0]));
        return new TestFileSystemManager(defaultRootLocation);
    }
}

