/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.schedulers.internal;

import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.schedulers.ExceptionHandlers;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.wires.input.BindableInputWire;
import com.swirlds.component.framework.wires.input.NoOpInputWire;
import com.swirlds.component.framework.wires.output.NoOpOutputWire;
import com.swirlds.component.framework.wires.output.StandardOutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Consumer;

public class NoOpTaskScheduler<OUT>
extends TaskScheduler<OUT> {
    private final TraceableWiringModel model;

    public NoOpTaskScheduler(@NonNull TraceableWiringModel model, @NonNull String name, @NonNull TaskSchedulerType type, boolean flushEnabled, boolean squelchingEnabled) {
        super(model, name, type, ExceptionHandlers.NOOP_UNCAUGHT_EXCEPTION, flushEnabled, squelchingEnabled, false);
        this.model = Objects.requireNonNull(model);
    }

    @Override
    public long getUnprocessedTaskCount() {
        return 0L;
    }

    @Override
    public long getCapacity() {
        return -1L;
    }

    @Override
    public void flush() {
        this.throwIfFlushDisabled();
    }

    @Override
    protected void put(@NonNull Consumer<Object> handler, @NonNull Object data) {
        throw new UnsupportedOperationException("Data should have been discarded before being sent to this no-op scheduler");
    }

    @Override
    protected boolean offer(@NonNull Consumer<Object> handler, @NonNull Object data) {
        throw new UnsupportedOperationException("Data should have been discarded before being sent to this no-op scheduler");
    }

    @Override
    protected void inject(@NonNull Consumer<Object> handler, @NonNull Object data) {
        throw new UnsupportedOperationException("Data should have been discarded before being sent to this no-op scheduler");
    }

    @Override
    @NonNull
    protected StandardOutputWire<OUT> buildPrimaryOutputWire(@NonNull TraceableWiringModel model, @NonNull String name) {
        return new NoOpOutputWire(model, this.getName());
    }

    @Override
    @NonNull
    public <T> StandardOutputWire<T> buildSecondaryOutputWire() {
        return new NoOpOutputWire(this.model, this.getName());
    }

    @Override
    @NonNull
    public <I> BindableInputWire<I, OUT> buildInputWire(@NonNull String name) {
        return new NoOpInputWire(this.model, this, name);
    }
}

