/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.block.api.codec;

import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.hapi.block.stream.MerkleSiblingHash;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hiero.block.api.BlockContentsProof;

public final class BlockContentsProofJsonCodec
implements JsonCodec<BlockContentsProof> {
    @NonNull
    public BlockContentsProof parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            BlockItem temp_block_item = null;
            List temp_sibling_hashes = Collections.emptyList();
            Bytes temp_block_signature = Bytes.EMPTY;
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "blockItem": {
                        temp_block_item = (BlockItem)BlockItem.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block12;
                    }
                    case "siblingHashes": {
                        temp_sibling_hashes = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), MerkleSiblingHash.JSON, (int)(maxDepth - 1));
                        continue block12;
                    }
                    case "blockSignature": {
                        temp_block_signature = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new BlockContentsProof(temp_block_item, temp_sibling_hashes, temp_block_signature);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull BlockContentsProof data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.blockItem() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"blockItem", BlockItem.JSON, (Object)data.blockItem()));
        }
        if (!data.siblingHashes().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"siblingHashes", MerkleSiblingHash.JSON, data.siblingHashes()));
        }
        if (data.blockSignature() != Bytes.EMPTY && data.blockSignature() != null && data.blockSignature().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"blockSignature", (Bytes)data.blockSignature()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

