/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.counters;

import com.swirlds.component.framework.counters.ObjectCounter;
import java.util.Objects;

public class MultiObjectCounter
extends ObjectCounter {
    private final ObjectCounter[] counters;

    public MultiObjectCounter(ObjectCounter ... counters) {
        this.counters = Objects.requireNonNull(counters);
        if (counters.length == 0) {
            throw new IllegalArgumentException("Must have at least one counter");
        }
    }

    @Override
    public void onRamp(long delta) {
        for (ObjectCounter counter : this.counters) {
            counter.onRamp(delta);
        }
    }

    @Override
    public boolean attemptOnRamp(long delta) {
        boolean success = this.counters[0].attemptOnRamp(delta);
        if (!success) {
            return false;
        }
        for (int i = 1; i < this.counters.length; ++i) {
            this.counters[i].forceOnRamp(delta);
        }
        return true;
    }

    @Override
    public void forceOnRamp(long delta) {
        for (ObjectCounter counter : this.counters) {
            counter.forceOnRamp(delta);
        }
    }

    @Override
    public void offRamp(long delta) {
        for (ObjectCounter counter : this.counters) {
            counter.offRamp(delta);
        }
    }

    @Override
    public long getCount() {
        return this.counters[0].getCount();
    }

    @Override
    public void waitUntilEmpty() {
        for (ObjectCounter counter : this.counters) {
            counter.waitUntilEmpty();
        }
    }
}

