/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fchashmap.internal;

import com.swirlds.fchashmap.internal.Mutation;
import com.swirlds.fchashmap.internal.PurgingEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class UnPurgedMap<K, V>
implements Iterable<PurgingEvent<K, V>> {
    private final long version;
    private UnPurgedMap<K, V> previous;
    private UnPurgedMap<K, V> next;
    private final List<PurgingEvent<K, V>> purgingEvents = new LinkedList<PurgingEvent<K, V>>();
    private boolean purged;

    public UnPurgedMap(long version) {
        this.version = version;
    }

    public void setPrevious(UnPurgedMap<K, V> previous) {
        this.previous = previous;
    }

    public UnPurgedMap<K, V> getPrevious() {
        return this.previous;
    }

    public UnPurgedMap<K, V> getNext() {
        return this.next;
    }

    public void setNext(UnPurgedMap<K, V> next) {
        this.next = next;
    }

    public long getVersion() {
        return this.version;
    }

    public synchronized boolean schedulePurging(K key, Mutation<V> mutation) {
        if (this.purged) {
            return false;
        }
        this.purgingEvents.add(new PurgingEvent<K, V>(key, mutation));
        return true;
    }

    public synchronized void markAsPurged() {
        this.purged = true;
    }

    @Override
    public Iterator<PurgingEvent<K, V>> iterator() {
        return this.purgingEvents.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("version ").append(this.version).append(", purge keys = ");
        for (PurgingEvent<K, V> event : this.purgingEvents) {
            sb.append(event).append(" ");
        }
        return sb.toString();
    }
}

