/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class ServiceEndpointJsonCodec
implements JsonCodec<ServiceEndpoint> {
    @NonNull
    public ServiceEndpoint parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            Bytes temp_ipAddressV4 = Bytes.EMPTY;
            int temp_port = 0;
            String temp_domain_name = "";
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "ipAddressV4": {
                        temp_ipAddressV4 = Bytes.fromBase64((String)JsonTools.checkSize((String)"ipAddressV4", (String)kvPair.value().STRING().getText(), (int)(maxSize < 0x3FFFFFFF ? maxSize * 2 : Integer.MAX_VALUE)));
                        continue block12;
                    }
                    case "port": {
                        temp_port = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block12;
                    }
                    case "domainName": {
                        temp_domain_name = JsonTools.unescape((String)JsonTools.checkSize((String)"domain_name", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new ServiceEndpoint(temp_ipAddressV4, temp_port, temp_domain_name);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull ServiceEndpoint data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.ipAddressV4() != Bytes.EMPTY && data.ipAddressV4() != null && data.ipAddressV4().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"ipAddressV4", (Bytes)data.ipAddressV4()));
        }
        if (data.port() != 0) {
            fieldLines.add(JsonTools.field((String)"port", (int)data.port()));
        }
        if (data.domainName() != "") {
            fieldLines.add(JsonTools.field((String)"domainName", (String)data.domainName()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

