/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.spi;

import com.swirlds.state.spi.QueueChangeListener;
import com.swirlds.state.spi.WritableQueueState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public abstract class WritableQueueStateBase<E>
implements WritableQueueState<E> {
    private final List<E> readElements = new ArrayList();
    private final List<E> addedElements = new ArrayList();
    private final List<QueueChangeListener<E>> listeners = new ArrayList<QueueChangeListener<E>>();
    private int currentAddedElementIndex = 0;
    private Iterator<E> dsIterator = null;
    private E peekedElement = null;
    protected final String label;
    protected final int stateId;

    protected WritableQueueStateBase(int stateId, String label) {
        this.stateId = stateId;
        this.label = label;
    }

    public boolean isModified() {
        return !this.readElements.isEmpty() || !this.addedElements.isEmpty();
    }

    public void registerListener(@NonNull QueueChangeListener<E> listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    public final void commit() {
        int i;
        int numReadFromAdded = this.currentAddedElementIndex > 0 ? this.currentAddedElementIndex - (this.peekedElement == null ? 0 : 1) : 0;
        int n = this.readElements.size() - numReadFromAdded;
        for (i = 0; i < n; ++i) {
            this.removeFromDataSource();
            this.listeners.forEach(QueueChangeListener::queuePopChange);
        }
        n = this.addedElements.size();
        for (i = numReadFromAdded; i < n; ++i) {
            Object addedElement = this.addedElements.get(i);
            this.addToDataSource(addedElement);
            this.listeners.forEach(l -> l.queuePushChange(addedElement));
        }
        this.reset();
    }

    public final void reset() {
        this.readElements.clear();
        this.addedElements.clear();
        this.peekedElement = null;
        this.dsIterator = null;
        this.currentAddedElementIndex = 0;
    }

    @Override
    public int getStateId() {
        return this.stateId;
    }

    @Override
    @Nullable
    public E peek() {
        if (this.peekedElement != null) {
            return this.peekedElement;
        }
        if (this.dsIterator == null) {
            this.dsIterator = this.iterateOnDataSource();
        }
        this.peekedElement = this.dsIterator.hasNext() ? this.dsIterator.next() : (this.currentAddedElementIndex < this.addedElements.size() ? this.addedElements.get(this.currentAddedElementIndex++) : null);
        return this.peekedElement;
    }

    @Override
    public void add(@NonNull E element) {
        this.addedElements.add(element);
    }

    @Override
    @Nullable
    public E removeIf(@NonNull Predicate<E> predicate) {
        E element = this.peek();
        if (element == null) {
            return null;
        }
        if (predicate.test(element)) {
            this.readElements.add(element);
            this.peekedElement = null;
            return element;
        }
        return null;
    }

    @Override
    @NonNull
    public Iterator<E> iterator() {
        final Iterator<E> iterator = this.iterateOnDataSource();
        final Iterator<E> addedElementsIterator = this.addedElements.iterator();
        final int numAddedElements = this.addedElements.size();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext() || addedElementsIterator.hasNext();
            }

            @Override
            public E next() {
                if (numAddedElements != WritableQueueStateBase.this.addedElements.size()) {
                    throw new ConcurrentModificationException();
                }
                return iterator.hasNext() ? iterator.next() : addedElementsIterator.next();
            }
        };
    }

    protected abstract void addToDataSource(@NonNull E var1);

    protected abstract void removeFromDataSource();

    @NonNull
    protected abstract Iterator<E> iterateOnDataSource();
}

